/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.CycleCount;
import com.silanis.esl.sdk.Plan;
import com.silanis.esl.sdk.Price;
import com.silanis.esl.sdk.Quota;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlanBuilder {
    private String contract;
    private String cycle;
    private Map<String, Object> data;
    private String description;
    private Map<String, Object> features;
    private CycleCount freeCycles;
    private String group;
    private String id;
    private String name;
    private String original;
    private Price price;
    private List<Quota> quotas = new ArrayList<Quota>();

    private PlanBuilder() {
        this.data = new HashMap<String, Object>();
        this.features = new HashMap<String, Object>();
    }

    public static PlanBuilder newPlan() {
        return new PlanBuilder();
    }

    public static PlanBuilder newPlan(String name) {
        return new PlanBuilder().withName(name);
    }

    public PlanBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public PlanBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public PlanBuilder withContract(String contract) {
        this.contract = contract;
        return this;
    }

    public PlanBuilder withCycle(String cycle) {
        this.cycle = cycle;
        return this;
    }

    public PlanBuilder withData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public PlanBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public PlanBuilder withFeatures(Map<String, Object> features) {
        this.features = features;
        return this;
    }

    public PlanBuilder withFreeCycles(CycleCount cycleCount) {
        this.freeCycles = cycleCount;
        return this;
    }

    public PlanBuilder withFreeCycles(Integer count, String cycle) {
        this.freeCycles = new CycleCount();
        this.freeCycles.setCount(count);
        this.freeCycles.setCycle(cycle);
        return this;
    }

    public PlanBuilder withGroup(String group) {
        this.group = group;
        return this;
    }

    public PlanBuilder withOriginal(String original) {
        this.original = original;
        return this;
    }

    public PlanBuilder withPrice(Price price) {
        this.price = price;
        return this;
    }

    public PlanBuilder withQuota(Quota quota) {
        this.quotas.add(quota);
        return this;
    }

    public PlanBuilder withQuota(String cycle, Integer limit, String scope, String target) {
        Quota quota = new Quota();
        quota.setCycle(cycle);
        quota.setLimit(limit);
        quota.setScope(scope);
        quota.setTarget(target);
        this.quotas.add(quota);
        return this;
    }

    public Plan build() {
        Plan plan = new Plan();
        plan.setContract(this.contract);
        plan.setData(this.data);
        plan.setName(this.name);
        plan.setId(this.id);
        plan.setCycle(this.cycle);
        plan.setDescription(this.description);
        plan.setPrice(this.price);
        plan.setFeatures(this.features);
        plan.setFreeCycles(this.freeCycles);
        plan.setOriginal(this.original);
        plan.setGroup(this.group);
        for (Quota quota : this.quotas) {
            plan.addQuota(quota);
        }
        return plan;
    }
}

