/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.TextAnchor;
import com.silanis.esl.sdk.TextAnchorPosition;

public class TextAnchorBuilder {
    private String anchorText;
    private int occurrence;
    private int character;
    private TextAnchorPosition position;
    private int xOffset;
    private int yOffset;
    private int width;
    private int height;

    private TextAnchorBuilder(String anchorText) {
        this.anchorText = anchorText;
    }

    public static TextAnchorBuilder newTextAnchor(String anchorText) {
        return new TextAnchorBuilder(anchorText);
    }

    public TextAnchorBuilder withOccurence(int occurence) {
        this.occurrence = occurence;
        return this;
    }

    public TextAnchorBuilder withCharacter(int character) {
        this.character = character;
        return this;
    }

    public TextAnchorBuilder atPosition(TextAnchorPosition position) {
        this.position = position;
        return this;
    }

    public TextAnchorBuilder withOffset(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
        return this;
    }

    public TextAnchorBuilder withSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public TextAnchor build() {
        TextAnchor result = new TextAnchor();
        result.setAnchorText(this.anchorText);
        result.setOccurrence(this.occurrence);
        result.setCharacter(this.character);
        result.setPosition(this.position);
        result.setXOffset(this.xOffset);
        result.setYOffset(this.yOffset);
        result.setWidth(this.width);
        result.setHeight(this.height);
        return result;
    }
}

