/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageAttributesBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import org.joda.time.DateMidnight;

public class DocumentPackageAttributesExample
extends SDKSample {
    public static final String DYNAMICS_2015 = "dynamics2015";
    public static final String ATTRIBUTE_KEY_1 = "Key 1";
    public static final String ATTRIBUTE_KEY_2 = "Key 2";
    public static final String ATTRIBUTE_KEY_3 = "Key 3";
    public static final String ATTRIBUTE_1 = "Attribute 1";
    public static final String ATTRIBUTE_2 = "Attribute 2";
    public static final String ATTRIBUTE_3 = "Attribute 3";

    public static void main(String ... args) {
        new DocumentPackageAttributesExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using OneSpan Sign SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).withField(FieldBuilder.checkBox().onPage(0).atPosition(400.0, 200.0).withValue("X")).atPosition(100.0, 100.0))).withOrigin(DYNAMICS_2015).withAttributes(DocumentPackageAttributesBuilder.newDocumentPackageAttributes().withAttribute(ATTRIBUTE_KEY_1, ATTRIBUTE_1).withAttribute(ATTRIBUTE_KEY_2, ATTRIBUTE_2).withAttribute(ATTRIBUTE_KEY_3, ATTRIBUTE_3)).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        SessionToken sessionToken = this.eslClient.getSessionService().createSessionToken(this.packageId.toString(), "Client1");
    }
}

