/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.List;
import org.joda.time.DateMidnight;

public class DocumentUploadExample
extends SDKSample {
    public static final String DOCUMENT1_NAME = "First Document";
    public static final String DOCUMENT2_NAME = "Second Document";
    public Document document1;
    public Document document2;
    public List<Document> uploadedDocuments;

    public static void main(String ... args) {
        new DocumentUploadExample().run();
    }

    @Override
    public void execute() {
        this.documentInputStream2 = this.getClass().getClassLoader().getResourceAsStream("taggedDocument.pdf");
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using OneSpan Sign SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        superDuperPackage.setId(this.packageId);
        this.document1 = DocumentBuilder.newDocumentWithName(DOCUMENT1_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).withField(FieldBuilder.checkBox().onPage(0).atPosition(400.0, 200.0).withValue("X")).atPosition(100.0, 100.0)).build();
        this.document2 = DocumentBuilder.newDocumentWithName(DOCUMENT2_NAME).fromStream(this.documentInputStream2, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).withField(FieldBuilder.checkBox().onPage(0).atPosition(400.0, 200.0).withValue("X")).atPosition(100.0, 100.0)).build();
        this.uploadedDocuments = this.eslClient.uploadDocuments(this.packageId, this.document1, this.document2);
        this.eslClient.sendPackage(superDuperPackage.getId());
        SessionToken sessionToken = this.eslClient.getSessionService().createSessionToken(superDuperPackage.getId().toString(), "Client1");
    }
}

