/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.CompletionReport;
import com.silanis.esl.sdk.DelegationReport;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.PackageStatus;
import com.silanis.esl.sdk.UsageReport;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.joda.time.DateMidnight;

public class DownloadReportExample
extends SDKSample {
    public PackageId package2Id;
    public CompletionReport sdkCompletionReportForSenderDraft;
    public CompletionReport sdkCompletionReportForSenderSent;
    public CompletionReport sdkCompletionReportDraft;
    public CompletionReport sdkCompletionReportSent;
    public UsageReport sdkUsageReport;
    public DelegationReport sdkDelegationReportForAccountWithoutDate;
    public DelegationReport sdkDelegationReportForAccount;
    public DelegationReport sdkDelegationReportForSender;
    public String csvCompletionReportForSenderDraft;
    public String csvCompletionReportForSenderSent;
    public String csvCompletionReportDraft;
    public String csvCompletionReportSent;
    public String csvUsageReport;
    public String csvDelegationReportForAccountWithoutDate;
    public String csvDelegationReportForAccount;
    public String csvDelegationReportForSender;

    public static void main(String ... args) {
        new DownloadReportExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using OneSpan Sign SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCustomId("signer1").withCompany("Acme Inc.")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0).withField(FieldBuilder.textField().onPage(0).atPosition(400.0, 100.0).withSize(200.0, 50.0)))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        DocumentPackage superDuperPackage2 = PackageBuilder.newPackageNamed("DownloadReportForSent " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using OneSpan Sign SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCustomId("signer1").withCompany("Acme Inc.")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream2, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0).withField(FieldBuilder.textField().onPage(0).atPosition(400.0, 100.0).withSize(200.0, 50.0)))).build();
        this.package2Id = this.eslClient.createAndSendPackage(superDuperPackage2);
        GregorianCalendar fromCalendar = new GregorianCalendar();
        ((Calendar)fromCalendar).add(12, -5);
        Date from = fromCalendar.getTime();
        GregorianCalendar toCalendar = new GregorianCalendar();
        toCalendar.setTime(new Date(System.currentTimeMillis()));
        ((Calendar)toCalendar).add(12, 5);
        Date to = toCalendar.getTime();
        this.sdkCompletionReportForSenderDraft = this.eslClient.getReportService().downloadCompletionReport(PackageStatus.DRAFT, this.senderUID, from, to);
        this.csvCompletionReportForSenderDraft = this.eslClient.getReportService().downloadCompletionReportAsCSV(PackageStatus.DRAFT, this.senderUID, from, to);
        this.sdkCompletionReportForSenderSent = this.eslClient.getReportService().downloadCompletionReport(PackageStatus.SENT, this.senderUID, from, to);
        this.csvCompletionReportForSenderSent = this.eslClient.getReportService().downloadCompletionReportAsCSV(PackageStatus.SENT, this.senderUID, from, to);
        this.sdkCompletionReportDraft = this.eslClient.getReportService().downloadCompletionReport(PackageStatus.DRAFT, from, to);
        this.csvCompletionReportDraft = this.eslClient.getReportService().downloadCompletionReportAsCSV(PackageStatus.DRAFT, from, to);
        this.sdkCompletionReportSent = this.eslClient.getReportService().downloadCompletionReport(PackageStatus.SENT, from, to);
        this.csvCompletionReportSent = this.eslClient.getReportService().downloadCompletionReportAsCSV(PackageStatus.SENT, from, to);
        this.sdkUsageReport = this.eslClient.getReportService().downloadUsageReport(from, to);
        this.csvUsageReport = this.eslClient.getReportService().downloadUsageReportAsCSV(from, to);
        this.sdkDelegationReportForAccountWithoutDate = this.eslClient.getReportService().downloadDelegationReport();
        this.sdkDelegationReportForAccount = this.eslClient.getReportService().downloadDelegationReport(from, to);
        this.sdkDelegationReportForSender = this.eslClient.getReportService().downloadDelegationReport(this.senderUID, from, to);
        this.csvDelegationReportForAccountWithoutDate = this.eslClient.getReportService().downloadDelegationReportAsCSV();
        this.csvDelegationReportForAccount = this.eslClient.getReportService().downloadDelegationReportAsCSV(from, to);
        this.csvDelegationReportForSender = this.eslClient.getReportService().downloadDelegationReportAsCSV(this.senderUID, from, to);
    }
}

