/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.FieldValidatorBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;

public class FieldValidatorsExample
extends SDKSample {
    public static final String DOCUMENT_NAME = "First Document";
    public static final FieldId FIELD_NUMERIC_ID = new FieldId("numeric");
    public static final int FIELD_NUMERIC_MAX_LENGTH = 10;
    public static final FieldId FIELD_ALPHABETIC_ID = new FieldId("alphabetic");
    public static final int FIELD_ALPHABETIC_MIN_LENGTH = 3;
    public static final int FIELD_ALPHABETIC_MAX_LENGTH = 10;
    public static final FieldId FIELD_ALPHANUMERIC_ID = new FieldId("alphanumeric");
    public static final int FIELD_ALPHANUMERIC_MIN_LENGTH = 5;
    public static final FieldId FIELD_URL_ID = new FieldId("url");
    public static final String FIELD_URL_ERROR_MESSAGE = "This is not a URL";
    public static final FieldId FIELD_EMAIL_ID = new FieldId("email");
    public static final FieldId FIELD_BASIC_ID = new FieldId("basic");
    public static final String FIELD_BASIC_OPTION_1 = "one";
    public static final String FIELD_BASIC_OPTION_2 = "two";
    public static final FieldId FIELD_REGEX_ID = new FieldId("regex");
    public static final String FIELD_REGEX_ERROR_MESSAGE = "This is not a valid email";
    public static final String FIELD_GROUP = "group";
    public static final String FIELD_GROUP_TOOLTIP = "group tooltip";
    public static final FieldId FIELD_CHECKBOX_ID_1 = new FieldId("checkbox_one");
    public static final FieldId FIELD_CHECKBOX_ID_2 = new FieldId("checkbox_two");
    public static final String FIELD_RADIO_GROUP = "RadioGroup";
    public static final String FIELD_RADIO_GROUP_TOOLTIP = "radio group tooltip";
    public static final FieldId FIELD_RADIO_ID_1 = new FieldId("radio_one");
    public static final FieldId FIELD_RADIO_ID_2 = new FieldId("radio_two");

    public static void main(String ... args) {
        new FieldValidatorsExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(500.0, 100.0).withField(FieldBuilder.textField().withId(FIELD_NUMERIC_ID).atPosition(500.0, 200.0).onPage(0).withValidation(FieldValidatorBuilder.numeric().maxLength(10))).withField(FieldBuilder.textField().withId(FIELD_ALPHABETIC_ID).atPosition(500.0, 300.0).onPage(0).withValidation(FieldValidatorBuilder.alphabetic().minLength(3).maxLength(10).required())).withField(FieldBuilder.textField().withId(FIELD_ALPHANUMERIC_ID).atPosition(500.0, 400.0).onPage(0).withValidation(FieldValidatorBuilder.alphanumeric().minLength(5))).withField(FieldBuilder.textField().withId(FIELD_URL_ID).atPosition(500.0, 500.0).onPage(0).withValidation(FieldValidatorBuilder.url().withErrorMessage(FIELD_URL_ERROR_MESSAGE))).withField(FieldBuilder.textField().withId(FIELD_EMAIL_ID).atPosition(500.0, 600.0).onPage(0).withValidation(FieldValidatorBuilder.email())).withField(FieldBuilder.textField().withId(FIELD_BASIC_ID).atPosition(500.0, 700.0).onPage(0).withValidation(FieldValidatorBuilder.basic().withOption(FIELD_BASIC_OPTION_1).withOption(FIELD_BASIC_OPTION_2).disabled())).withField(FieldBuilder.textField().withId(FIELD_REGEX_ID).atPosition(500.0, 700.0).onPage(0).withValidation(FieldValidatorBuilder.regex("^([a-z0-9_\\.-]+)@([\\da-z\\.-]+)\\.([a-z\\.]{2,6})$").withErrorMessage(FIELD_REGEX_ERROR_MESSAGE))).withField(FieldBuilder.checkBox().withId(FIELD_CHECKBOX_ID_1).atPosition(500.0, 800.0).onPage(0).withValidation(FieldValidatorBuilder.basic().setGroup(FIELD_GROUP).setMinimumRequired(1).setMaximumRequired(2).setGroupTooltip(FIELD_GROUP_TOOLTIP))).withField(FieldBuilder.radioButton(FIELD_RADIO_GROUP).withId(FIELD_RADIO_ID_1).atPosition(500.0, 500.0).onPage(0).withValidation(FieldValidatorBuilder.basic().setGroup(FIELD_RADIO_GROUP).setGroupTooltip(FIELD_RADIO_GROUP_TOOLTIP))).withField(FieldBuilder.radioButton(FIELD_RADIO_GROUP).withId(FIELD_RADIO_ID_2).atPosition(500.0, 500.0).onPage(0).withValidation(FieldValidatorBuilder.basic().setGroup(FIELD_RADIO_GROUP).setGroupTooltip(FIELD_RADIO_GROUP_TOOLTIP))).withField(FieldBuilder.checkBox().withId(FIELD_CHECKBOX_ID_2).atPosition(550.0, 800.0).onPage(0).withValidation(FieldValidatorBuilder.basic().setGroup(FIELD_GROUP).setMinimumRequired(1).setMaximumRequired(2).setGroupTooltip(FIELD_GROUP_TOOLTIP))))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
    }
}

