/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.UUID;

public class GetSigningUrlExample
extends SDKSample {
    public String signingUrlForSigner1;
    public String signingUrlForSigner2;

    public static void main(String ... args) {
        new GetSigningUrlExample().run();
    }

    @Override
    public void execute() {
        String signer1Id = UUID.randomUUID().toString();
        String signer2Id = UUID.randomUUID().toString();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using OneSpan Sign SDK").withSettings(DocumentPackageSettingsBuilder.newDocumentPackageSettings().withInPerson()).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John1").withLastName("Smith1").withCustomId(signer1Id)).withSigner(SignerBuilder.newSignerWithEmail(this.email2).withFirstName("John2").withLastName("Smith2").withCustomId(signer2Id)).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0)).withSignature(SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(100.0, 200.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(this.packageId);
        this.signingUrlForSigner1 = this.eslClient.getPackageService().getSigningUrl(this.packageId, signer1Id);
        this.signingUrlForSigner2 = this.eslClient.getPackageService().getSigningUrl(this.packageId, signer2Id);
    }
}

