/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.ExtractionType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Page;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.Visibility;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ListTemplatesExample
extends SDKSample {
    public static final String TEMPLATE_DESCRIPTION = "This is a template created using OneSpan Sign SDK";
    public static final String TEMPLATE_EMAIL_MESSAGE = "This message should be delivered to all signers";
    public static final String TEMPLATE_SIGNER_FIRST = "John";
    public static final String TEMPLATE_SIGNER_LAST = "Smith";
    public static final String DOCUMENT1_NAME = "First Document";
    public static final String DOCUMENT2_NAME = "Second Document";
    public static final String DOCUMENT3_NAME = "Third Document";
    public static final String DOCUMENT_ID = "doc1";
    public PackageId templateId;
    public String packageName;
    private Page<DocumentPackage> templatesPage;
    private List<DocumentPackage> templates = new ArrayList<DocumentPackage>();
    private InputStream documentInputStream3;

    public static void main(String ... args) {
        new ListTemplatesExample().run();
    }

    @Override
    public void execute() {
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document_with_text_tag_and_form_field.pdf");
        this.documentInputStream2 = this.getClass().getClassLoader().getResourceAsStream("document_with_text_tag_and_form_field.pdf");
        this.documentInputStream3 = this.getClass().getClassLoader().getResourceAsStream("document_with_text_tag_and_form_field.pdf");
        this.packageName = this.getPackageName();
        DocumentPackage superDuperTemplate = PackageBuilder.newPackageNamed(this.packageName).describedAs(TEMPLATE_DESCRIPTION).withEmailMessage(TEMPLATE_EMAIL_MESSAGE).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName(TEMPLATE_SIGNER_FIRST).withLastName(TEMPLATE_SIGNER_LAST)).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT1_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).enableExtraction()).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT2_NAME).fromStream(this.documentInputStream2, DocumentType.PDF).withExtractionType(ExtractionType.TEXT_TAGS).enableExtraction()).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT3_NAME).fromStream(this.documentInputStream3, DocumentType.PDF).withExtractionType(ExtractionType.TEXT_TAGS).withExtractionType(ExtractionType.ACROFIELDS).enableExtraction()).build();
        this.templateId = this.eslClient.getTemplateService().createTemplate(superDuperTemplate);
        this.templatesPage = this.eslClient.getPackageService().getTemplates(new PageRequest(0), Visibility.SENDER);
        this.templates.addAll(this.templatesPage.getResults());
    }

    public List<DocumentPackage> getTemplates() {
        return this.templates;
    }
}

