/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AuthenticationClient;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.AccountMemberBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SenderInfoBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.logging.Logger;

public class PackageViewRedirectForPackageSenderExample
extends SDKSample {
    private static final Logger logger = Logger.getLogger(PackageViewRedirectForPackageSenderExample.class.getName());
    public String generatedLinkToPackageViewForSender;
    private AuthenticationClient authenticationClient;

    public static void main(String ... args) {
        new PackageViewRedirectForPackageSenderExample().run();
    }

    public PackageViewRedirectForPackageSenderExample() {
        this.authenticationClient = new AuthenticationClient(this.webpageUrl);
    }

    @Override
    public void execute() {
        this.eslClient.getAccountService().inviteUser(AccountMemberBuilder.newAccountMember(this.senderEmail).withFirstName("firstName").withLastName("lastName").withCompany("company").withTitle("title").withPhoneNumber("phoneNumber").build());
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withSenderInfo(SenderInfoBuilder.newSenderInfo(this.senderEmail).withName("firstName", "lastName").withTitle("title").withCompany("company")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.senderEmail).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        String userAuthenticationToken = this.eslClient.getAuthenticationTokensService().createUserAuthenticationToken();
        this.generatedLinkToPackageViewForSender = this.authenticationClient.buildRedirectToPackageViewForSender(userAuthenticationToken, this.packageId.getId());
        logger.info(this.generatedLinkToPackageViewForSender);
    }
}

