/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AccountMember;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.Sender;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.SenderStatus;
import com.silanis.esl.sdk.builder.AccountMemberBuilder;
import com.silanis.esl.sdk.builder.SenderInfoBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.Map;

public class SenderManipulationExample
extends SDKSample {
    public AccountMember accountMember1;
    public AccountMember accountMember2;
    public AccountMember accountMember3;
    public SenderInfo updatedSenderInfo;
    Sender retrievedSender1;
    Sender retrievedSender2;
    Sender retrievedSender3;
    Sender retrievedUpdatedSender3;

    public static void main(String ... args) {
        new SenderManipulationExample().run();
    }

    public SenderManipulationExample() {
        this.email1 = this.getRandomEmail();
        this.email2 = this.getRandomEmail();
        this.email3 = this.getRandomEmail();
    }

    @Override
    public void execute() {
        this.accountMember1 = AccountMemberBuilder.newAccountMember(this.email1).withFirstName("firstName1").withLastName("lastName1").withCompany("company1").withTitle("title1").withLanguage("language1").withPhoneNumber("phoneNumber1").withTimezoneId("GMT").withStatus(SenderStatus.ACTIVE).build();
        this.accountMember2 = AccountMemberBuilder.newAccountMember(this.email2).withFirstName("firstName2").withLastName("lastName2").withCompany("company2").withTitle("title2").withLanguage("language2").withPhoneNumber("phoneNumber2").withStatus(SenderStatus.ACTIVE).build();
        this.accountMember3 = AccountMemberBuilder.newAccountMember(this.email3).withFirstName("firstName3").withLastName("lastName3").withCompany("company3").withTitle("title3").withLanguage("language3").withPhoneNumber("phoneNumber3").withStatus(SenderStatus.ACTIVE).build();
        Sender createdSender1 = this.eslClient.getAccountService().inviteUser(this.accountMember1);
        Sender createdSender2 = this.eslClient.getAccountService().inviteUser(this.accountMember2);
        Sender createdSender3 = this.eslClient.getAccountService().inviteUser(this.accountMember3);
        this.retrievedSender1 = this.eslClient.getAccountService().getSender(createdSender1.getId());
        this.retrievedSender2 = this.eslClient.getAccountService().getSender(createdSender2.getId());
        this.retrievedSender3 = this.eslClient.getAccountService().getSender(createdSender3.getId());
        this.eslClient.getAccountService().sendInvite(createdSender2.getId());
        this.eslClient.getAccountService().deleteSender(createdSender2.getId());
        this.updatedSenderInfo = SenderInfoBuilder.newSenderInfo(this.email3).withName("updatedFirstName", "updatedLastName").withTitle("updatedTitle").withCompany("updatedCompany").withTimezoneId("Canada/Mountain").build();
        this.eslClient.getAccountService().updateSender(this.updatedSenderInfo, createdSender3.getId());
        this.retrievedUpdatedSender3 = this.eslClient.getAccountService().getSender(createdSender3.getId());
        Map<String, Sender> senders = this.eslClient.getAccountService().getSenders(Direction.ASCENDING, new PageRequest(1, 100));
    }
}

