/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AuthenticationClient;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.UUID;
import java.util.logging.Logger;

public class SigningRedirectForSignerExample
extends SDKSample {
    private static final Logger logger = Logger.getLogger(SigningRedirectForSignerExample.class.getName());
    private AuthenticationClient authenticationClient;
    public String generatedLinkToSigningForSigner;

    public static void main(String ... args) {
        new SigningRedirectForSignerExample().run();
    }

    public SigningRedirectForSignerExample() {
        this.authenticationClient = new AuthenticationClient(this.webpageUrl);
    }

    @Override
    public void execute() {
        String signerId = UUID.randomUUID().toString();
        DocumentPackage packageToCreate = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using OneSpan Sign SDK").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.").withCustomId(signerId)).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        this.packageId = this.eslClient.createPackage(packageToCreate);
        this.eslClient.sendPackage(this.packageId);
        String signerAuthenticationToken = this.eslClient.getAuthenticationTokensService().createSignerAuthenticationToken(this.packageId.getId(), signerId);
        this.generatedLinkToSigningForSigner = this.authenticationClient.buildRedirectToSigningForSigner(signerAuthenticationToken, this.packageId.getId());
        logger.info(this.generatedLinkToSigningForSigner);
    }
}

