/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.Locale;

public class UpdateSignerExample
extends SDKSample {
    public DocumentPackage updatedPackage;
    public static final String SIGNER1_CUSTOM_ID = "signerId1";
    public static final String SIGNER1_FIRST_NAME = "John1";
    public static final String SIGNER1_LAST_NAME = "Smith1";
    public static final String SIGNER2_CUSTOM_ID = "signerId2";
    public static final String SIGNER2_FIRST_NAME = "Patty";
    public static final String SIGNER2_LAST_NAME = "Galant";
    public static final Locale SIGNER2_LANGUAGE = Locale.FRENCH;
    public static final Locale SIGNER2_UPDATE_LANGUAGE = Locale.SIMPLIFIED_CHINESE;
    public static final String SIGNER3_FIRST_NAME = "John2";
    public static final String SIGNER3_LAST_NAME = "Smith2";
    public static final String SIGNER3_FIRST_QUESTION = "What's 1+1?";
    public static final String SIGNER3_FIRST_ANSWER = "2";
    public static final String SIGNER3_SECOND_QUESTION = "What color's the sky?";
    public static final String SIGNER3_SECOND_ANSWER = "blue";

    public static void main(String ... args) {
        new UpdateSignerExample().run();
    }

    @Override
    public void execute() {
        Signer signer1 = SignerBuilder.newSignerWithEmail(this.email1).withFirstName(SIGNER1_FIRST_NAME).withLastName(SIGNER1_LAST_NAME).withCustomId(SIGNER1_CUSTOM_ID).build();
        Signer signer2 = SignerBuilder.newSignerWithEmail(this.email2).withFirstName(SIGNER2_FIRST_NAME).withLastName(SIGNER2_LAST_NAME).withLanguage(SIGNER2_LANGUAGE).withCustomId(SIGNER2_CUSTOM_ID).build();
        Signer signer3 = SignerBuilder.newSignerWithEmail(this.email3).withFirstName(SIGNER3_FIRST_NAME).withLastName(SIGNER3_LAST_NAME).challengedWithQuestions(SignerBuilder.ChallengeBuilder.firstQuestion(SIGNER3_FIRST_QUESTION).answer(SIGNER3_FIRST_ANSWER).secondQuestion(SIGNER3_SECOND_QUESTION).answer(SIGNER3_SECOND_ANSWER)).withCustomId(SIGNER1_CUSTOM_ID).build();
        Signer signer4 = SignerBuilder.newSignerWithEmail(this.email2).withFirstName(SIGNER2_FIRST_NAME).withLastName(SIGNER2_LAST_NAME).withLanguage(SIGNER2_UPDATE_LANGUAGE).withCustomId(SIGNER2_CUSTOM_ID).build();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).withLanguage(Locale.JAPANESE).withSettings(DocumentPackageSettingsBuilder.newDocumentPackageSettings().withInPerson()).withSigner(signer1).withSigner(signer2).withDocument(DocumentBuilder.newDocumentWithName("doc1").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(30.0, 100.0)).withSignature(SignatureBuilder.signatureFor(this.email2).onPage(0).atPosition(30.0, 300.0))).build();
        PackageId packageId = this.eslClient.createPackage(superDuperPackage);
        this.eslClient.sendPackage(packageId);
        this.retrievedPackage = this.eslClient.getPackage(packageId);
        this.eslClient.changePackageStatusToDraft(packageId);
        this.eslClient.getPackageService().updateSigner(packageId, signer3);
        this.eslClient.getPackageService().updateSigner(packageId, signer4);
        this.eslClient.sendPackage(packageId);
        this.updatedPackage = this.eslClient.getPackage(packageId);
    }
}

