/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageAttributesBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;

public class VaultingDataExample
extends SDKSample {
    public static final String PACKAGE_NAME = "packageName";
    public static final String VAULTING_DATA_KEY = "vaulting_data";
    public static final String VAULTING_DATA_OLD_VALUE = "base64EncodedOldVaultingData";
    public static final String VAULTING_DATA_NEW_VALUE = "base64EncodedNewVaultingData";
    public DocumentPackage packageToCreate;
    public DocumentPackage createdPackage;
    public DocumentPackage packageToUpdate;
    public DocumentPackage updatedPackage;

    public static void main(String ... args) {
        new VaultingDataExample().run();
    }

    @Override
    public void execute() {
        DocumentPackageAttributesBuilder documentPackageAttributesBuilder = DocumentPackageAttributesBuilder.newDocumentPackageAttributes();
        this.packageToCreate = PackageBuilder.newPackageNamed(PACKAGE_NAME).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John1").withLastName("Smith1")).withDocument(DocumentBuilder.newDocumentWithName("First Document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).withAttributes(documentPackageAttributesBuilder.withAttribute(VAULTING_DATA_KEY, VAULTING_DATA_OLD_VALUE)).build();
        this.packageId = this.eslClient.createPackage(this.packageToCreate);
        this.createdPackage = this.eslClient.getPackage(this.packageId);
        this.packageToUpdate = PackageBuilder.newPackageNamed(PACKAGE_NAME).withAttributes(documentPackageAttributesBuilder.withAttribute(VAULTING_DATA_KEY, VAULTING_DATA_NEW_VALUE)).build();
        this.eslClient.updateVaultingData(this.packageId, this.packageToUpdate);
        this.eslClient.getVaultingData(this.packageId);
        this.eslClient.revault(this.packageId);
        this.updatedPackage = this.eslClient.getPackage(this.packageId);
    }
}

