/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.Auth;
import com.silanis.esl.api.model.AuthChallenge;
import com.silanis.esl.sdk.Authentication;
import com.silanis.esl.sdk.AuthenticationMethod;
import com.silanis.esl.sdk.Challenge;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.internal.converter.AuthenticationMethodConverter;
import com.silanis.esl.sdk.internal.converter.ChallengeConverter;
import com.silanis.esl.sdk.internal.converter.IdvWorkflowConverter;
import java.util.ArrayList;

public class AuthenticationConverter {
    Auth apiAuth;
    Authentication sdkAuth;

    public AuthenticationConverter(Auth apiAuth) {
        this.apiAuth = apiAuth;
    }

    public AuthenticationConverter(Authentication sdkAuth) {
        this.sdkAuth = sdkAuth;
    }

    public Auth toAPIAuthentication() {
        if (this.sdkAuth == null) {
            return this.apiAuth;
        }
        Auth auth = new Auth().setScheme(new AuthenticationMethodConverter(this.sdkAuth.getMethod()).toAPIAuthMethod());
        for (Challenge challenge : this.sdkAuth.getChallenges()) {
            auth.addChallenge(new AuthChallenge().setQuestion(challenge.getQuestion()).setAnswer(challenge.getAnswer()).setMaskInput(challenge.getMaskOption() == Challenge.MaskOptions.MaskInput).setChallengeType(challenge.getChallengeType()));
        }
        if (this.sdkAuth.getPhoneNumber() != null) {
            auth.addChallenge(new AuthChallenge().setQuestion(this.sdkAuth.getPhoneNumber()));
        }
        if (this.sdkAuth.getIdvWorkflow() != null) {
            auth.setIdvWorkflow(new IdvWorkflowConverter(this.sdkAuth.getIdvWorkflow()).toAPIIdvWorkflow());
        }
        return auth;
    }

    public Authentication toSDKAuthentication() {
        if (this.apiAuth == null) {
            return this.sdkAuth;
        }
        String telephoneNumber = null;
        this.sdkAuth = SignerBuilder.AuthenticationBuilder.newAuthenticationWithMethod(new AuthenticationMethodConverter(this.apiAuth.getScheme()).toSDKAuthMethod()).build();
        if (!this.apiAuth.getChallenges().isEmpty()) {
            ArrayList<Challenge> sdkChallenges = new ArrayList<Challenge>();
            for (AuthChallenge apiChallenge : this.apiAuth.getChallenges()) {
                if ("CHALLENGE".equals(this.apiAuth.getScheme())) {
                    sdkChallenges.add(new ChallengeConverter(apiChallenge).toSDKChallenge());
                    continue;
                }
                if ("QASMS".equals(this.apiAuth.getScheme())) {
                    sdkChallenges.add(new ChallengeConverter(apiChallenge).toSDKQASMSChallenge());
                    continue;
                }
                telephoneNumber = apiChallenge.getQuestion();
                break;
            }
            if ("CHALLENGE".equals(this.apiAuth.getScheme())) {
                this.sdkAuth = new Authentication(sdkChallenges);
            } else if ("QASMS".equals(this.apiAuth.getScheme())) {
                this.sdkAuth = new Authentication(AuthenticationMethod.QASMS, sdkChallenges);
            } else if ("SMS".equals(this.apiAuth.getScheme())) {
                this.sdkAuth = new Authentication(AuthenticationMethod.SMS, telephoneNumber);
            } else if ("ID_VERIFICATION".equals(this.apiAuth.getScheme())) {
                this.sdkAuth = new Authentication(AuthenticationMethod.IDV, telephoneNumber, new IdvWorkflowConverter(this.apiAuth.getIdvWorkflow()).toSDKIdvWorkflow());
            }
        }
        return this.sdkAuth;
    }
}

