/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.AuthChallenge;
import com.silanis.esl.sdk.Challenge;

public class ChallengeConverter {
    private AuthChallenge apiChallenge = null;
    private Challenge sdkChallenge = null;

    public ChallengeConverter(AuthChallenge apiChallenge) {
        this.apiChallenge = apiChallenge;
    }

    public ChallengeConverter(Challenge sdkChallenge) {
        this.sdkChallenge = sdkChallenge;
    }

    public AuthChallenge toAPIChallenge() {
        if (this.sdkChallenge == null) {
            return this.apiChallenge;
        }
        AuthChallenge apiChallenge = new AuthChallenge();
        apiChallenge.setQuestion(this.sdkChallenge.getQuestion());
        apiChallenge.setAnswer(this.sdkChallenge.getAnswer());
        apiChallenge.setMaskInput(this.sdkChallenge.getMaskOption() == Challenge.MaskOptions.MaskInput);
        return apiChallenge;
    }

    public Challenge toSDKChallenge() {
        if (this.apiChallenge == null) {
            return this.sdkChallenge;
        }
        Challenge sdkChallenge = new Challenge(this.apiChallenge.getQuestion(), this.apiChallenge.getAnswer(), this.apiChallenge.getMaskInput() != false ? Challenge.MaskOptions.MaskInput : Challenge.MaskOptions.None);
        return sdkChallenge;
    }

    public Challenge toSDKQASMSChallenge() {
        if (this.apiChallenge == null) {
            return this.sdkChallenge;
        }
        Challenge sdkChallenge = new Challenge(this.apiChallenge.getChallengeType() != null ? this.apiChallenge.getChallengeType() : null, this.apiChallenge.getQuestion(), this.apiChallenge.getAnswer(), this.apiChallenge.getMaskInput() != false ? Challenge.MaskOptions.MaskInput : Challenge.MaskOptions.None);
        return sdkChallenge;
    }
}

