/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Optional;
import com.silanis.esl.sdk.CcExpiration;
import com.silanis.esl.sdk.CreditCard;

public class CreditCardConverter {
    private Optional<com.silanis.esl.api.model.CreditCard> apiCreditCardOptional;
    private Optional<CreditCard> sdkCreditCardOptional;

    public CreditCardConverter(com.silanis.esl.api.model.CreditCard apiCreditCard) {
        this.apiCreditCardOptional = Optional.fromNullable((Object)apiCreditCard);
        this.sdkCreditCardOptional = Optional.absent();
    }

    public CreditCardConverter(CreditCard sdkCreditCard) {
        this.apiCreditCardOptional = Optional.absent();
        this.sdkCreditCardOptional = Optional.fromNullable((Object)sdkCreditCard);
    }

    public com.silanis.esl.api.model.CreditCard toAPICreditCard() {
        if (this.sdkCreditCardOptional.isPresent()) {
            com.silanis.esl.api.model.CreditCard apiCreditCard = new com.silanis.esl.api.model.CreditCard();
            CreditCard sdkCreditCard = (CreditCard)this.sdkCreditCardOptional.get();
            apiCreditCard.setCvv(sdkCreditCard.getCvv());
            apiCreditCard.setName(sdkCreditCard.getName());
            apiCreditCard.setNumber(sdkCreditCard.getNumber());
            apiCreditCard.setType(sdkCreditCard.getType());
            if (sdkCreditCard.getExpiration() != null) {
                com.silanis.esl.api.model.CcExpiration apiCcExpiration = new com.silanis.esl.api.model.CcExpiration();
                apiCcExpiration.setMonth(sdkCreditCard.getExpiration().getMonth());
                apiCcExpiration.setYear(sdkCreditCard.getExpiration().getYear());
                apiCreditCard.setExpiration(apiCcExpiration);
            }
            return apiCreditCard;
        }
        return (com.silanis.esl.api.model.CreditCard)this.apiCreditCardOptional.orNull();
    }

    public CreditCard toSDKCreditCard() {
        if (this.apiCreditCardOptional.isPresent()) {
            CreditCard sdkCreditCard = new CreditCard();
            com.silanis.esl.api.model.CreditCard apiCreditCard = (com.silanis.esl.api.model.CreditCard)this.apiCreditCardOptional.get();
            sdkCreditCard.setCvv(apiCreditCard.getCvv());
            sdkCreditCard.setNumber(apiCreditCard.getNumber());
            sdkCreditCard.setName(apiCreditCard.getName());
            sdkCreditCard.setType(apiCreditCard.getType());
            if (apiCreditCard.getExpiration() != null) {
                CcExpiration sdkCcExpiration = new CcExpiration();
                sdkCcExpiration.setYear(apiCreditCard.getExpiration().getYear());
                sdkCcExpiration.setMonth(apiCreditCard.getExpiration().getMonth());
                sdkCreditCard.setExpiration(sdkCcExpiration);
            }
            return sdkCreditCard;
        }
        return (CreditCard)this.sdkCreditCardOptional.orNull();
    }
}

