/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.CeremonyEventComplete;
import com.silanis.esl.api.model.CeremonyEvents;
import com.silanis.esl.api.model.CeremonySettings;
import com.silanis.esl.api.model.DocumentToolbarOptions;
import com.silanis.esl.api.model.Link;
import com.silanis.esl.api.model.PackageSettings;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.IntegrationFrameworkWorkflow;
import com.silanis.esl.sdk.internal.converter.CeremonyLayoutSettingsConverter;
import com.silanis.esl.sdk.internal.converter.IntegrationFrameworkWorkflowConverter;
import java.util.ArrayList;

public class DocumentPackageSettingsConverter {
    private DocumentPackageSettings sdkPackageSettings = null;
    private PackageSettings apiPackageSettings = null;

    public DocumentPackageSettingsConverter(PackageSettings apiPackageSettings) {
        this.apiPackageSettings = apiPackageSettings;
    }

    public DocumentPackageSettingsConverter(DocumentPackageSettings sdkPackageSettings) {
        this.sdkPackageSettings = sdkPackageSettings;
    }

    public PackageSettings toAPIPackageSettings() {
        if (this.sdkPackageSettings == null) {
            return this.apiPackageSettings;
        }
        CeremonySettings ceremonySettings = new CeremonySettings();
        ceremonySettings.safeSetInPerson(this.sdkPackageSettings.getEnableInPerson());
        ceremonySettings.safeSetOptOutButton(this.sdkPackageSettings.getEnableOptOut());
        ceremonySettings.safeSetDeclineButton(this.sdkPackageSettings.getEnableDecline());
        ceremonySettings.safeSetHideWatermark(this.sdkPackageSettings.getHideWatermark());
        ceremonySettings.safeSetHideCaptureText(this.sdkPackageSettings.getHideCaptureText());
        ceremonySettings.safeSetDeclineReasons(this.sdkPackageSettings.getDeclineReasons());
        ceremonySettings.safeSetOptOutReasons(this.sdkPackageSettings.getOptOutReasons());
        ceremonySettings.safeSetMaxAuthFailsAllowed(this.sdkPackageSettings.getMaxAuthAttempts());
        ceremonySettings.safeSetDisableDeclineOther(this.sdkPackageSettings.getDisableDeclineOther());
        ceremonySettings.safeSetDisableOptOutOther(this.sdkPackageSettings.getDisableOptOutOther());
        ceremonySettings.safeSetEnforceCaptureSignature(this.sdkPackageSettings.getEnforceCaptureSignature());
        ceremonySettings.safeSetAda(this.sdkPackageSettings.getAda());
        ceremonySettings.safeSetFontSize(this.sdkPackageSettings.getFontSize());
        ceremonySettings.safeSetDefaultTimeBasedExpiry(this.sdkPackageSettings.getDefaultTimeBasedExpiry());
        ceremonySettings.safeSetRemainingDays(this.sdkPackageSettings.getRemainingDays());
        ceremonySettings.safeSetShowNseHelp(this.sdkPackageSettings.getShowNseHelp());
        ceremonySettings.safeSetLeftMenuExpand(this.sdkPackageSettings.getExpandLeftMenu());
        ceremonySettings.safeSetMaxAttachmentFiles(this.sdkPackageSettings.getMaxAttachmentFiles());
        ceremonySettings.safeSetShowNseOverview(this.sdkPackageSettings.getShowNseOverview());
        ceremonySettings.safeSetShowNseLogoInIframe(this.sdkPackageSettings.getShowNseLogoInIframe());
        if (this.sdkPackageSettings.getEnableFirstAffidavit() != null) {
            ceremonySettings.safeSetDisableFirstInPersonAffidavit(this.sdkPackageSettings.getEnableFirstAffidavit() == false);
        }
        if (this.sdkPackageSettings.getEnableSecondAffidavit() != null) {
            ceremonySettings.safeSetDisableSecondInPersonAffidavit(this.sdkPackageSettings.getEnableSecondAffidavit() == false);
        }
        if (this.sdkPackageSettings.getShowLanguageDropDown() != null) {
            ceremonySettings.safeSetHideLanguageDropdown(this.sdkPackageSettings.getShowLanguageDropDown() == false);
        }
        if (this.sdkPackageSettings.getShowPackageOwnerInPerson() != null) {
            ceremonySettings.safeSetHidePackageOwnerInPerson(this.sdkPackageSettings.getShowPackageOwnerInPerson() == false);
        }
        if (this.sdkPackageSettings.getLinkHref() != null) {
            Link link = new Link();
            link.setHref(this.sdkPackageSettings.getLinkHref());
            link.setText(this.sdkPackageSettings.getLinkText() == null ? this.sdkPackageSettings.getLinkHref() : this.sdkPackageSettings.getLinkText());
            link.setTitle(this.sdkPackageSettings.getLinkTooltip() == null ? this.sdkPackageSettings.getLinkHref() : this.sdkPackageSettings.getLinkTooltip());
            link.setAutoRedirect(this.sdkPackageSettings.getLinkAutoRedirect() == null ? false : this.sdkPackageSettings.getLinkAutoRedirect());
            link.setParameters(this.sdkPackageSettings.getLinkParameters());
            ceremonySettings.setHandOver(link);
        }
        if (this.sdkPackageSettings.getShowDialogOnComplete() != null) {
            CeremonyEvents ceremonyEvents = new CeremonyEvents();
            CeremonyEventComplete ceremonyEventComplete = new CeremonyEventComplete();
            ceremonyEventComplete.setDialog(this.sdkPackageSettings.getShowDialogOnComplete());
            ceremonyEvents.setComplete(ceremonyEventComplete);
            ceremonySettings.setEvents(ceremonyEvents);
        }
        if (this.sdkPackageSettings.getShowDocumentToolbarDownloadButton() != null) {
            DocumentToolbarOptions documentToolbarOptions = new DocumentToolbarOptions();
            documentToolbarOptions.setDownloadButton(this.sdkPackageSettings.getShowDocumentToolbarDownloadButton());
            ceremonySettings.setDocumentToolbarOptions(documentToolbarOptions);
        }
        if (this.sdkPackageSettings.getCeremonyLayoutSettings() != null) {
            ceremonySettings.setLayout(new CeremonyLayoutSettingsConverter(this.sdkPackageSettings.getCeremonyLayoutSettings()).toAPILayoutOptions());
        }
        ArrayList<com.silanis.esl.api.model.IntegrationFrameworkWorkflow> apiIntegrationFrameworkWorkflow = new ArrayList<com.silanis.esl.api.model.IntegrationFrameworkWorkflow>();
        for (IntegrationFrameworkWorkflow sdkIfWorkflow : this.sdkPackageSettings.getIntegrationFrameworkWorkflows()) {
            apiIntegrationFrameworkWorkflow.add(IntegrationFrameworkWorkflowConverter.toAPI(sdkIfWorkflow));
        }
        PackageSettings result = new PackageSettings();
        result.setCeremony(ceremonySettings);
        result.setIntegrationFrameworkWorkflows(apiIntegrationFrameworkWorkflow);
        return result;
    }

    public DocumentPackageSettings toSDKPackageSettings() {
        if (this.apiPackageSettings == null) {
            return this.sdkPackageSettings;
        }
        DocumentPackageSettings result = new DocumentPackageSettings();
        result.setEnableInPerson(this.apiPackageSettings.getCeremony().evalInPerson());
        result.setEnableOptOut(this.apiPackageSettings.getCeremony().evalOptOutButton());
        result.setEnableDecline(this.apiPackageSettings.getCeremony().evalDeclineButton());
        result.setExpandLeftMenu(this.apiPackageSettings.getCeremony().evalLeftMenuExpand());
        result.setHideWatermark(this.apiPackageSettings.getCeremony().evalHideWatermark());
        result.setHideCaptureText(this.apiPackageSettings.getCeremony().getHideCaptureText());
        result.getDeclineReasons().addAll(this.apiPackageSettings.getCeremony().getDeclineReasons());
        result.getOptOutReasons().addAll(this.apiPackageSettings.getCeremony().getOptOutReasons());
        if (this.apiPackageSettings.getCeremony().getHideLanguageDropdown() != null) {
            result.setShowLanguageDropDown(this.apiPackageSettings.getCeremony().getHideLanguageDropdown() == false);
        }
        if (this.apiPackageSettings.getCeremony().getHidePackageOwnerInPerson() != null) {
            result.setShowPackageOwnerInPerson(this.apiPackageSettings.getCeremony().getHidePackageOwnerInPerson() == false);
        }
        if (this.apiPackageSettings.getCeremony().getDisableFirstInPersonAffidavit() != null) {
            result.setEnableFirstAffidavit(this.apiPackageSettings.getCeremony().getDisableFirstInPersonAffidavit() == false);
        }
        if (this.apiPackageSettings.getCeremony().getDisableSecondInPersonAffidavit() != null) {
            result.setEnableSecondAffidavit(this.apiPackageSettings.getCeremony().getDisableSecondInPersonAffidavit() == false);
        }
        if (this.apiPackageSettings.getCeremony().getMaxAuthFailsAllowed() != null) {
            result.setMaxAuthAttempts(this.apiPackageSettings.getCeremony().getMaxAuthFailsAllowed());
        }
        if (this.apiPackageSettings.getCeremony().getDocumentToolbarOptions() != null) {
            result.setShowDocumentToolbarDownloadButton(this.apiPackageSettings.getCeremony().getDocumentToolbarOptions().evalDownloadButton());
        }
        if (this.apiPackageSettings.getCeremony().getEvents() != null && this.apiPackageSettings.getCeremony().getEvents().getComplete() != null) {
            result.setShowDialogOnComplete(this.apiPackageSettings.getCeremony().getEvents().getComplete().evalDialog());
        }
        if (this.apiPackageSettings.getCeremony().getHandOver() != null) {
            result.setLinkText(this.apiPackageSettings.getCeremony().getHandOver().getText());
            result.setLinkTooltip(this.apiPackageSettings.getCeremony().getHandOver().getTitle());
            result.setLinkHref(this.apiPackageSettings.getCeremony().getHandOver().getHref());
            result.setLinkAutoRedirect(this.apiPackageSettings.getCeremony().getHandOver().getAutoRedirect());
            result.setLinkParameters(this.apiPackageSettings.getCeremony().getHandOver().getParameters());
        }
        if (this.apiPackageSettings.getCeremony().getDisableDeclineOther() != null) {
            result.setDisableDeclineOther(this.apiPackageSettings.getCeremony().getDisableDeclineOther());
        }
        if (this.apiPackageSettings.getCeremony().getDisableOptOutOther() != null) {
            result.setDisableOptOutOther(this.apiPackageSettings.getCeremony().getDisableOptOutOther());
        }
        if (this.apiPackageSettings.getCeremony().getEnforceCaptureSignature() != null) {
            result.setEnforceCaptureSignature(this.apiPackageSettings.getCeremony().getEnforceCaptureSignature());
        }
        if (this.apiPackageSettings.getCeremony().getAda() != null) {
            result.setAda(this.apiPackageSettings.getCeremony().getAda());
        }
        if (this.apiPackageSettings.getCeremony().getFontSize() != null) {
            result.setFontSize(this.apiPackageSettings.getCeremony().getFontSize());
        }
        if (this.apiPackageSettings.getCeremony().getDefaultTimeBasedExpiry() != null) {
            result.setDefaultTimeBasedExpiry(this.apiPackageSettings.getCeremony().getDefaultTimeBasedExpiry());
        }
        if (this.apiPackageSettings.getCeremony().getRemainingDays() != null) {
            result.setRemainingDays(this.apiPackageSettings.getCeremony().getRemainingDays());
        }
        if (this.apiPackageSettings.getCeremony().getShowNseHelp() != null) {
            result.setShowNseHelp(this.apiPackageSettings.getCeremony().getShowNseHelp());
        }
        if (this.apiPackageSettings.getCeremony().getMaxAttachmentFiles() != null) {
            result.setMaxAttachmentFiles(this.apiPackageSettings.getCeremony().getMaxAttachmentFiles());
        }
        if (this.apiPackageSettings.getCeremony().getShowNseOverview() != null) {
            result.setShowNseOverview(this.apiPackageSettings.getCeremony().getShowNseOverview());
        }
        if (this.apiPackageSettings.getCeremony().getShowNseLogoInIframe() != null) {
            result.setShowNseLogoInIframe(this.apiPackageSettings.getCeremony().getShowNseLogoInIframe());
        }
        ArrayList<IntegrationFrameworkWorkflow> integrationFrameworkWorkflowsSDK = new ArrayList<IntegrationFrameworkWorkflow>();
        for (com.silanis.esl.api.model.IntegrationFrameworkWorkflow apiIfWorkflow : this.apiPackageSettings.getIntegrationFrameworkWorkflows()) {
            integrationFrameworkWorkflowsSDK.add(IntegrationFrameworkWorkflowConverter.toSDK(apiIfWorkflow));
        }
        result.setIntegrationFrameworkWorkflows(integrationFrameworkWorkflowsSDK);
        result.setCeremonyLayoutSettings(new CeremonyLayoutSettingsConverter(this.apiPackageSettings.getCeremony().getLayout()).toSDKCeremonyLayoutSettings());
        return result;
    }
}

