/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.FieldType;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class FieldTypeConverter {
    private FieldType sdkFieldType = null;
    private String apiFieldType = null;

    public FieldTypeConverter(String apiFieldType) {
        this.apiFieldType = apiFieldType;
    }

    public FieldTypeConverter(FieldType sdkFieldType) {
        this.sdkFieldType = sdkFieldType;
    }

    public String toAPIFieldType() {
        if (this.sdkFieldType == null) {
            return this.apiFieldType;
        }
        return this.sdkFieldType.getApiValue();
    }

    public FieldType toSDKFieldType() {
        if (this.apiFieldType == null) {
            return this.sdkFieldType;
        }
        try {
            return (FieldType)Iterables.find(Arrays.asList(FieldType.values()), (Predicate)new Predicate<FieldType>(){

                public boolean apply(FieldType fieldType) {
                    return FieldTypeConverter.this.apiFieldType.equals(fieldType.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return FieldType.UNRECOGNIZED(this.apiFieldType);
        }
    }
}

