/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.User;
import com.silanis.esl.sdk.Message;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.internal.converter.MessageStatusConverter;
import java.util.ArrayList;
import java.util.HashMap;

public class MessageConverter {
    private Message sdkMessage = null;
    private com.silanis.esl.api.model.Message apiMessage = null;

    public MessageConverter(com.silanis.esl.api.model.Message apiMessage) {
        this.apiMessage = apiMessage;
    }

    public MessageConverter(Message sdkMessage) {
        this.sdkMessage = sdkMessage;
    }

    public com.silanis.esl.api.model.Message toAPIMessage() {
        if (this.sdkMessage == null) {
            return this.apiMessage;
        }
        com.silanis.esl.api.model.Message result = new com.silanis.esl.api.model.Message();
        if (this.sdkMessage.getContent() != null) {
            result.setContent(this.sdkMessage.getContent());
        }
        if (this.sdkMessage.getFrom() != null) {
            Signer fromSigner = this.sdkMessage.getFrom();
            User fromUser = new User();
            fromUser.setEmail(fromSigner.getEmail());
            fromUser.setFirstName(fromSigner.getFirstName());
            fromUser.setLastName(fromSigner.getLastName());
            fromUser.setId(fromSigner.getId());
            fromUser.setCompany(fromSigner.getCompany());
            fromUser.setTitle(fromSigner.getTitle());
            result.setFrom(fromUser);
        }
        if (this.sdkMessage.getTo() != null && !this.sdkMessage.getTo().isEmpty()) {
            ArrayList<User> toUsers = new ArrayList<User>();
            for (Signer toSigner : this.sdkMessage.getTo().values()) {
                User toUser = new User();
                toUser.setEmail(toSigner.getEmail());
                toUser.setFirstName(toSigner.getFirstName());
                toUser.setLastName(toSigner.getLastName());
                toUser.setCompany(toSigner.getCompany());
                toUser.setTitle(toSigner.getTitle());
                toUsers.add(toUser);
            }
            result.setTo(toUsers);
        }
        if (this.sdkMessage.getCreated() != null) {
            result.setCreated(this.sdkMessage.getCreated());
        }
        if (this.sdkMessage.getStatus() != null) {
            result.setStatus(new MessageStatusConverter(this.sdkMessage.getStatus()).toAPIMessageStatus());
        }
        return result;
    }

    public Message toSDKMessage() {
        if (this.apiMessage == null) {
            return this.sdkMessage;
        }
        User fromUser = this.apiMessage.getFrom();
        Signer fromSigner = SignerBuilder.newSignerWithEmail(fromUser.getEmail()).withCompany(fromUser.getCompany()).withFirstName(fromUser.getFirstName()).withLastName(fromUser.getLastName()).withCustomId(fromUser.getId()).withTitle(fromUser.getTitle()).build();
        Message result = new Message(new MessageStatusConverter(this.apiMessage.getStatus()).toSDKMessageStatus(), this.apiMessage.getContent(), fromSigner);
        if (this.apiMessage.getTo() != null && !this.apiMessage.getTo().isEmpty()) {
            HashMap<String, Signer> toSigners = new HashMap<String, Signer>();
            for (User toUser : this.apiMessage.getTo()) {
                Signer to = SignerBuilder.newSignerWithEmail(toUser.getEmail()).withCompany(toUser.getCompany()).withFirstName(toUser.getFirstName()).withLastName(toUser.getLastName()).withCustomId(toUser.getId()).withTitle(toUser.getTitle()).build();
                toSigners.put(to.getEmail().toLowerCase(), to);
            }
            result.setTo(toSigners);
        }
        if (this.apiMessage.getCreated() != null) {
            result.setCreated(this.apiMessage.getCreated());
        }
        return result;
    }
}

