/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.silanis.esl.sdk.MessageStatus;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class MessageStatusConverter {
    private String apiMessageStatus = null;
    private MessageStatus sdkMessageStatus = null;

    public MessageStatusConverter(String apiMessageStatus) {
        this.apiMessageStatus = apiMessageStatus;
    }

    public MessageStatusConverter(MessageStatus sdkMessageStatus) {
        this.sdkMessageStatus = sdkMessageStatus;
    }

    public MessageStatus toSDKMessageStatus() {
        if (this.apiMessageStatus == null) {
            return this.sdkMessageStatus;
        }
        try {
            return (MessageStatus)Iterables.find(Arrays.asList(MessageStatus.values()), (Predicate)new Predicate<MessageStatus>(){

                public boolean apply(MessageStatus messageStatus) {
                    return MessageStatusConverter.this.apiMessageStatus.equals(messageStatus.getApiValue());
                }
            });
        }
        catch (NoSuchElementException e) {
            return MessageStatus.UNRECOGNIZED(this.apiMessageStatus);
        }
    }

    public String toAPIMessageStatus() {
        if (this.sdkMessageStatus == null) {
            return this.apiMessageStatus;
        }
        return this.sdkMessageStatus.getApiValue();
    }
}

