/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.oauth;

import com.silanis.esl.sdk.internal.Asserts;

public class OAuthTokenConfig {
    private final String grantType;
    private final String clientId;
    private final String clientSecret;
    private final String authenticationServer;

    private OAuthTokenConfig(Builder builder) {
        this.authenticationServer = builder.authenticationServer;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.grantType = builder.grantType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAuthenticationURL() {
        return String.format("%s?grant_type=%s", this.getAuthenticationServer(), this.getGrantType());
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAuthenticationServer() {
        return this.authenticationServer;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String toString() {
        return String.format("OAuthTokenConfig{ '%s':'%s', '%s': '%s', '%s': '%s'}", "authenticationServerUrl", this.authenticationServer, "clientId'", this.clientId, "clientSecret", "*********");
    }

    public static final class Builder {
        private String grantType = "client_credentials";
        private String clientId;
        private String clientSecret;
        private String authenticationServer;

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withAuthenticationServer(String authenticationServer) {
            this.authenticationServer = authenticationServer;
            return this;
        }

        public OAuthTokenConfig build() {
            Asserts.notNullOrEmpty(this.clientId, "clientId");
            Asserts.notNullOrEmpty(this.clientSecret, "clientSecret");
            Asserts.notNullOrEmpty(this.authenticationServer, "authenticationServer");
            Asserts.notNullOrEmpty(this.grantType, "grantType");
            return new OAuthTokenConfig(this);
        }
    }
}

