/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.provider;

import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.internal.Asserts;
import java.util.HashMap;
import java.util.Map;

public class EslOAuthClientConfig {
    private String clientId;
    private String clientSecret;
    private String authenticationServer;
    private String apiUrl;
    private boolean allowAllSSLCertificatesFlag;
    private ProxyConfiguration proxyConfig;
    private boolean useSystemProperties;
    private Map<String, String> headers;

    private EslOAuthClientConfig(String clientId, String clientSecret, String authenticationServer, String apiUrl, boolean allowAllSSLCertificatesFlag, ProxyConfiguration proxyConfig, boolean useSystemProperties, Map<String, String> headers) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authenticationServer = authenticationServer;
        this.apiUrl = apiUrl;
        this.allowAllSSLCertificatesFlag = allowAllSSLCertificatesFlag;
        this.proxyConfig = proxyConfig;
        this.useSystemProperties = useSystemProperties;
        this.headers = headers;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAuthenticationServer() {
        return this.authenticationServer;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public boolean getAllowAllSSLCertificatesFlag() {
        return this.allowAllSSLCertificatesFlag;
    }

    public ProxyConfiguration getProxyConfig() {
        return this.proxyConfig;
    }

    public boolean getUseSystemProperties() {
        return this.useSystemProperties;
    }

    public String toString() {
        return String.format("OneSpanClient{ '%s':'%s', '%s': '%s', '%s': '%s', '%s': '%s', '%s': '%s'}", "authenticationServerUrl", this.authenticationServer, "clientId'", this.clientId, "apiUrl", this.apiUrl, "allowAllSSLCertificatesFlag", this.allowAllSSLCertificatesFlag, "useSystemProperties", this.useSystemProperties);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static final class Builder {
        private String clientId;
        private String clientSecret;
        private String authenticationServer;
        private String apiUrl;
        private boolean allowAllSSLCertificatesFlag;
        private ProxyConfiguration proxyConfig;
        private boolean useSystemProperties;
        private Map<String, String> headers = new HashMap<String, String>();

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder withAuthenticationServer(String authenticationServer) {
            this.authenticationServer = authenticationServer;
            return this;
        }

        public Builder withApiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder withAllowAllSSLCertificatesFlag(boolean allowAllSSLCertificatesFlag) {
            this.allowAllSSLCertificatesFlag = allowAllSSLCertificatesFlag;
            return this;
        }

        public Builder withProxyConfiguration(ProxyConfiguration proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        public Builder withUseSystemProperties(boolean useSystemProperties) {
            this.useSystemProperties = useSystemProperties;
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public EslOAuthClientConfig build() {
            Asserts.notNullOrEmpty(this.clientId, "clientId");
            Asserts.notNullOrEmpty(this.clientSecret, "clientSecret");
            Asserts.notNullOrEmpty(this.authenticationServer, "authenticationServer");
            Asserts.notNullOrEmpty(this.apiUrl, "apiUrl");
            return new EslOAuthClientConfig(this.clientId, this.clientSecret, this.authenticationServer, this.apiUrl, this.allowAllSSLCertificatesFlag, this.proxyConfig, this.useSystemProperties, this.headers);
        }
    }
}

