/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.provider;

import com.silanis.esl.sdk.EslClient;
import com.silanis.esl.sdk.oauth.OAuthTokenConfig;
import com.silanis.esl.sdk.provider.EslOAuthClientConfig;
import java.util.concurrent.ConcurrentHashMap;

public class EslOAuthClientProvider {
    private static final Object mutex = new Object();
    private static volatile EslOAuthClientProvider instance;
    private final ConcurrentHashMap<String, EslClient> clients = new ConcurrentHashMap();

    private EslOAuthClientProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EslOAuthClientProvider getInstance() {
        EslOAuthClientProvider localInstance = instance;
        if (localInstance == null) {
            Object object = mutex;
            synchronized (object) {
                localInstance = instance;
                if (localInstance == null) {
                    instance = localInstance = new EslOAuthClientProvider();
                }
            }
        }
        return localInstance;
    }

    public EslClient getEslClient(EslOAuthClientConfig config) {
        return this.clients.compute(config.getClientId(), (key, value) -> this.computeEslClient((EslClient)value, config));
    }

    private EslClient computeEslClient(EslClient eslClient, EslOAuthClientConfig config) {
        if (eslClient == null || !eslClient.getoAuthTokenConfig().getClientSecret().equals(config.getClientSecret())) {
            eslClient = this.createNewClient(config);
        }
        return eslClient;
    }

    protected EslClient createNewClient(EslOAuthClientConfig config) {
        OAuthTokenConfig authTokenConfig = OAuthTokenConfig.builder().withAuthenticationServer(config.getAuthenticationServer()).withClientId(config.getClientId()).withClientSecret(config.getClientSecret()).build();
        return new EslClient(authTokenConfig, config.getApiUrl(), config.getAllowAllSSLCertificatesFlag(), config.getProxyConfig(), config.getUseSystemProperties(), config.getHeaders());
    }
}

