/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.UserCustomField;
import com.silanis.esl.sdk.CustomField;
import com.silanis.esl.sdk.CustomFieldValue;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.internal.converter.CustomFieldConverter;
import com.silanis.esl.sdk.internal.converter.CustomFieldValueConverter;
import com.silanis.esl.sdk.service.apiclient.CustomFieldApiClient;
import java.util.ArrayList;
import java.util.List;

public class CustomFieldService {
    private CustomFieldApiClient apiClient;

    public CustomFieldService(CustomFieldApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CustomField createCustomField(CustomField customField) {
        com.silanis.esl.api.model.CustomField apiRequest = new CustomFieldConverter(customField).toAPICustomField();
        com.silanis.esl.api.model.CustomField apiResponse = this.apiClient.createCustomField(apiRequest);
        return new CustomFieldConverter(apiResponse).toSDKCustomField();
    }

    public boolean doesCustomFieldExist(String id) {
        return this.apiClient.doesCustomFieldExist(id);
    }

    public CustomField getCustomField(String id) {
        com.silanis.esl.api.model.CustomField apiCustomField = this.apiClient.getCustomField(id);
        return new CustomFieldConverter(apiCustomField).toSDKCustomField();
    }

    public List<CustomField> getCustomFields(Direction direction) {
        return this.getCustomFields(direction, new PageRequest(0, -1));
    }

    public List<CustomField> getCustomFields(Direction direction, PageRequest request) {
        List<com.silanis.esl.api.model.CustomField> customFieldList = this.apiClient.getCustomFields(direction, request);
        ArrayList<CustomField> result = new ArrayList<CustomField>();
        for (com.silanis.esl.api.model.CustomField apiCustomField : customFieldList) {
            result.add(new CustomFieldConverter(apiCustomField).toSDKCustomField());
        }
        return result;
    }

    public void deleteCustomField(String id) {
        this.apiClient.deleteCustomField(id);
    }

    public List<CustomFieldValue> getCustomFieldValues() {
        List<UserCustomField> userCustomFields = this.apiClient.getUserCustomFields();
        ArrayList<CustomFieldValue> customFieldValues = new ArrayList<CustomFieldValue>();
        for (UserCustomField userCustomField : userCustomFields) {
            customFieldValues.add(new CustomFieldValueConverter(userCustomField).toSDKCustomFieldValue());
        }
        return customFieldValues;
    }

    public CustomFieldValue getCustomFieldValue(String customFieldId) {
        UserCustomField userCustomField = this.apiClient.getUserCustomField(customFieldId);
        return new CustomFieldValueConverter(userCustomField).toSDKCustomFieldValue();
    }

    public CustomFieldValue submitCustomFieldValue(CustomFieldValue customFieldValue) {
        UserCustomField userCustomField = new CustomFieldValueConverter(customFieldValue).toAPIUserCustomField();
        UserCustomField result = this.apiClient.submitCustomFieldValue(userCustomField);
        return new CustomFieldValueConverter(result).toSDKCustomFieldValue();
    }

    public void deleteCustomFieldValue(String id) {
        this.apiClient.deleteUserCustomField(id);
    }

    public boolean doesCustomFieldValueExist(String id) {
        return this.apiClient.doesCustomFieldValueExist(id);
    }
}

