/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.DataManagementPolicy;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.ExpiryTimeConfiguration;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.DataManagementPolicyConverter;
import com.silanis.esl.sdk.internal.converter.ExpiryTimeConfigurationConverter;
import com.silanis.esl.sdk.service.EslComponent;

public class DataRetentionSettingsService
extends EslComponent {
    public DataRetentionSettingsService(RestClient client, String baseUrl) {
        super(client, baseUrl);
    }

    public ExpiryTimeConfiguration getExpiryTimeConfiguration() {
        String stringResponse;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/dataRetentionSettings/expiryTimeConfiguration").build();
        try {
            stringResponse = this.getClient().get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get expiryTimeConfiguration.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get expiryTimeConfiguration.", e);
        }
        com.silanis.esl.api.model.ExpiryTimeConfiguration expiryTimeConfiguration = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.ExpiryTimeConfiguration.class);
        ExpiryTimeConfigurationConverter converter = new ExpiryTimeConfigurationConverter(expiryTimeConfiguration);
        return converter.toSDKExpiryTimeConfiguration();
    }

    public void setExpiryTimeConfiguration(ExpiryTimeConfiguration expiryTimeConfiguration) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/dataRetentionSettings/expiryTimeConfiguration").build();
        ExpiryTimeConfigurationConverter converter = new ExpiryTimeConfigurationConverter(expiryTimeConfiguration);
        String expiryTimeConfigurationJson = Serialization.toJson(converter.toAPIExpiryTimeConfiguration());
        try {
            this.getClient().put(path, expiryTimeConfigurationJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update expiryTimeConfiguration", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update expiryTimeConfiguration", e);
        }
    }

    public DataManagementPolicy getDataManagementPolicy() {
        String stringResponse;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/dataRetentionSettings/dataManagementPolicy").build();
        try {
            stringResponse = this.getClient().get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get dataManagementPolicy.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get dataManagementPolicy.", e);
        }
        com.silanis.esl.api.model.DataManagementPolicy dataManagementPolicy = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.DataManagementPolicy.class);
        DataManagementPolicyConverter converter = new DataManagementPolicyConverter(dataManagementPolicy);
        return converter.toSDKDataManagementPolicy();
    }

    public void setDataManagementPolicy(DataManagementPolicy dataManagementPolicy) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/dataRetentionSettings/dataManagementPolicy").build();
        DataManagementPolicyConverter converter = new DataManagementPolicyConverter(dataManagementPolicy);
        String dataManagementPolicyJson = Serialization.toJson(converter.toAPIDataManagementPolicy());
        try {
            this.getClient().put(path, dataManagementPolicyJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update dataManagementPolicy", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update dataManagementPolicy", e);
        }
    }
}

