/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Package;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import com.silanis.esl.sdk.service.EslComponent;

public class EOriginalService
extends EslComponent {
    public EOriginalService(RestClient restClient, String baseUrl) {
        super(restClient, baseUrl);
    }

    public void updateVaultingData(PackageId packageId, DocumentPackage sdkPackage) throws EslException {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/eOriginalVault/vaultingData").replace("{packageId}", packageId.getId()).build();
        Package aPackage = new DocumentPackageConverter(sdkPackage).toAPIPackage();
        String packageJson = Serialization.toJson(aPackage);
        try {
            this.getClient().put(path, packageJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update the package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update the package.", e);
        }
    }

    public void getVaultingData(PackageId packageId) throws EslException {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/eOriginalVault/vaultingData").replace("{packageId}", packageId.getId()).build();
        try {
            this.getClient().get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the package.", e);
        }
    }

    public void revault(PackageId packageId) throws EslException {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/eOriginalVault/revault").replace("{packageId}", packageId.getId()).build();
        try {
            this.getClient().post(path, null);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not revault the package.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not revault the package.", e);
        }
    }
}

