/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Callback;
import com.silanis.esl.sdk.EventNotificationConfig;
import com.silanis.esl.sdk.builder.EventNotificationConfigBuilder;
import com.silanis.esl.sdk.internal.converter.EventNotificationConfigConverter;
import com.silanis.esl.sdk.service.apiclient.EventNotificationApiClient;

public class EventNotificationService {
    private EventNotificationApiClient apiClient;

    public EventNotificationService(EventNotificationApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void register(EventNotificationConfig config) {
        Callback callback = new EventNotificationConfigConverter(config).toAPICallback();
        this.apiClient.register(callback);
    }

    public void register(String origin, EventNotificationConfig config) {
        Callback callback = new EventNotificationConfigConverter(config).toAPICallback();
        this.apiClient.register(origin, callback);
    }

    public void register(EventNotificationConfigBuilder builder) {
        this.register(builder.build());
    }

    public void register(String origin, EventNotificationConfigBuilder builder) {
        this.register(origin, builder.build());
    }

    public EventNotificationConfig getEventNotificationConfig() {
        Callback apiResponse = this.apiClient.getEventNotificationConfig();
        return new EventNotificationConfigConverter(apiResponse).toSDKEventNotificationConfig();
    }

    public EventNotificationConfig getEventNotificationConfig(String origin) {
        Callback apiResponse = this.apiClient.getEventNotificationConfig(origin);
        return new EventNotificationConfigConverter(apiResponse).toSDKEventNotificationConfig();
    }
}

