/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.FieldSummary;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.service.EslComponent;
import java.util.List;

public class FieldSummaryService
extends EslComponent {
    public FieldSummaryService(RestClient client, String baseUrl) {
        super(client, baseUrl);
    }

    public List<FieldSummary> getFieldSummary(PackageId packageId) throws EslException {
        List<FieldSummary> fieldSummary;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/fieldSummary").replace("{packageId}", packageId.getId()).build();
        try {
            String stringResponse = this.getClient().get(path);
            fieldSummary = Serialization.fromJsonToList(stringResponse, FieldSummary.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the field summary.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the field summary.", e);
        }
        return fieldSummary;
    }
}

