/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.Group;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.GroupMember;
import com.silanis.esl.sdk.GroupSummary;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.GroupConverter;
import com.silanis.esl.sdk.internal.converter.GroupMemberConverter;
import com.silanis.esl.sdk.internal.converter.GroupSummaryConverter;
import com.silanis.esl.sdk.service.EslComponent;
import java.util.ArrayList;
import java.util.List;

public class GroupService
extends EslComponent {
    public GroupService(RestClient client, String baseUrl) {
        super(client, baseUrl);
    }

    public List<Group> getMyGroups() {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups").build();
        return this.getGroups(path);
    }

    public List<Group> getMyGroups(String groupName) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups").addParam("name", groupName).build();
        return this.getGroups(path);
    }

    private List<Group> getGroups(String path) {
        try {
            String stringResponse = this.getClient().get(path);
            Result<com.silanis.esl.api.model.Group> apiResponse = JacksonUtil.deserialize(stringResponse, new TypeReference<Result<com.silanis.esl.api.model.Group>>(){});
            ArrayList<Group> result = new ArrayList<Group>();
            for (com.silanis.esl.api.model.Group apiGroup : apiResponse.getResults()) {
                result.add(new GroupConverter(apiGroup).toSDKGroup());
            }
            return result;
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to retrieve Groups list.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve Groups list.", e);
        }
    }

    public Group getGroup(GroupId groupId) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups/{groupId}").replace("{groupId}", groupId.getId()).build();
        try {
            String stringResponse = this.getClient().get(path);
            com.silanis.esl.api.model.Group apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.Group.class);
            return new GroupConverter(apiResponse).toSDKGroup();
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to retrieve Group.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve Group.", e);
        }
    }

    public Group createGroup(Group group) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups").build();
        com.silanis.esl.api.model.Group apiGroup = new GroupConverter(group).toAPIGroupWithoutMembers();
        try {
            String stringResponse = this.getClient().post(path, Serialization.toJson(apiGroup));
            com.silanis.esl.api.model.Group apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.Group.class);
            Group resultGroup = new GroupConverter(apiResponse).toSDKGroup();
            for (GroupMember groupMember : group.getMembers()) {
                this.addMember(resultGroup.getId(), groupMember);
            }
            return resultGroup;
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to create Group.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to create Group.", e);
        }
    }

    public Group updateGroup(Group group, GroupId groupId) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups/{groupId}").replace("{groupId}", groupId.getId()).build();
        com.silanis.esl.api.model.Group apiGroup = new GroupConverter(group).toAPIGroup();
        try {
            String stringResponse = this.getClient().put(path, Serialization.toJson(apiGroup));
            com.silanis.esl.api.model.Group apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.Group.class);
            Group resultGroup = new GroupConverter(apiResponse).toSDKGroup();
            return resultGroup;
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to update Group.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to update Group.", e);
        }
    }

    public GroupMember addMember(GroupId groupId, GroupMember groupMember) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups/{groupId}/members").build().replace("{groupId}", groupId.getId());
        com.silanis.esl.api.model.GroupMember apiGroupMember = new GroupMemberConverter(groupMember).toAPIGroupMember();
        try {
            String stringResponse = this.getClient().post(path, Serialization.toJson(apiGroupMember));
            com.silanis.esl.api.model.GroupMember apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.GroupMember.class);
            GroupMember resultGroupMember = new GroupMemberConverter(apiResponse).toSDKGroupMember();
            return resultGroupMember;
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to add member to group.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to add member to group.", e);
        }
    }

    public Group inviteMember(GroupId groupId, GroupMember groupMember) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups/{groupId}/invite").build().replace("{groupId}", groupId.getId());
        com.silanis.esl.api.model.GroupMember apiGroupMember = new GroupMemberConverter(groupMember).toAPIGroupMember();
        try {
            String stringResponse = this.getClient().post(path, Serialization.toJson(apiGroupMember));
            com.silanis.esl.api.model.Group apiResponse = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.Group.class);
            Group resultGroup = new GroupConverter(apiResponse).toSDKGroup();
            return resultGroup;
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to invite member to group.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to invite member to group.", e);
        }
    }

    public void deleteGroup(GroupId groupId) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups/{groupId}").replace("{groupId}", groupId.getId()).build();
        try {
            this.getClient().delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to delete Group.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to delete Group.", e);
        }
    }

    public List<String> getGroupMemberEmails(GroupId groupId) {
        ArrayList<String> result = null;
        Group group = this.getGroup(groupId);
        if (group != null) {
            result = new ArrayList<String>();
            for (GroupMember groupMember : group.getMembers()) {
                result.add(groupMember.getEmail());
            }
        }
        return result;
    }

    public List<GroupMember> getGroupMembers(GroupId groupId) {
        List<GroupMember> result = null;
        Group group = this.getGroup(groupId);
        if (group != null) {
            result = group.getMembers();
        }
        return result;
    }

    public List<GroupSummary> getGroupSummaries() {
        ArrayList<GroupSummary> result = new ArrayList<GroupSummary>();
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/groups/summary").build();
        try {
            String stringResponse = this.getClient().get(path);
            Result<com.silanis.esl.api.model.GroupSummary> apiResponse = JacksonUtil.deserialize(stringResponse, new TypeReference<Result<com.silanis.esl.api.model.GroupSummary>>(){});
            for (com.silanis.esl.api.model.GroupSummary apiGroupSummary : apiResponse.getResults()) {
                result.add(new GroupSummaryConverter(apiGroupSummary).toSDKGroupSummary());
            }
            return result;
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to retrieve Group Summary list.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve Group Summary list.", e);
        }
    }
}

