/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.FieldId;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.FieldConverter;
import com.silanis.esl.sdk.service.EslComponent;
import java.util.ArrayList;
import java.util.List;

public class QRCodeService
extends EslComponent {
    public QRCodeService(RestClient restClient, String baseUrl) {
        super(restClient, baseUrl);
    }

    public FieldId addQRCode(PackageId packageId, String documentId, Field qrCodeField) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/documents/{documentId}/fields").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).build();
        com.silanis.esl.api.model.Field apiField = new FieldConverter(qrCodeField).toAPIField();
        String json = Serialization.toJson(apiField);
        try {
            String response = this.getClient().post(path, json);
            com.silanis.esl.api.model.Field result = Serialization.fromJson(response, com.silanis.esl.api.model.Field.class);
            return new FieldId(result.getId());
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add QR code to document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add QR code to document. Exception: " + e.getMessage());
        }
    }

    public void modifyQRCode(PackageId packageId, String documentId, Field qrCodeField) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/documents/{documentId}/fields/{fieldId}").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).replace("{fieldId}", qrCodeField.getId().getId()).build();
        com.silanis.esl.api.model.Field apiField = new FieldConverter(qrCodeField).toAPIField();
        String json = Serialization.toJson(apiField);
        try {
            this.getClient().put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not modify QR code in document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not modify QR code in document. Exception: " + e.getMessage());
        }
    }

    public Field getQRCode(PackageId packageId, String documentId, FieldId qrCodeId) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/documents/{documentId}/fields/{fieldId}").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).replace("{fieldId}", qrCodeId.getId()).build();
        try {
            String response = this.getClient().get(path);
            com.silanis.esl.api.model.Field apiField = Serialization.fromJson(response, com.silanis.esl.api.model.Field.class);
            return new FieldConverter(apiField).toSDKField();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get QR code from document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get QR code from document. Exception: " + e.getMessage());
        }
    }

    public void deleteQRCode(PackageId packageId, String documentId, FieldId qrCodeId) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/documents/{documentId}/fields/{fieldId}").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).replace("{fieldId}", qrCodeId.getId()).build();
        try {
            this.getClient().delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete QR code from document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete QR code from document. Exception: " + e.getMessage());
        }
    }

    public void updateQRCodes(PackageId packageId, String documentId, List<Field> qrCodeList) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/documents/{documentId}/fields").replace("{packageId}", packageId.getId()).replace("{documentId}", documentId).build();
        ArrayList<com.silanis.esl.api.model.Field> fieldList = new ArrayList<com.silanis.esl.api.model.Field>();
        for (Field sdkField : qrCodeList) {
            com.silanis.esl.api.model.Field apiField = new FieldConverter(sdkField).toAPIField();
            fieldList.add(apiField);
        }
        try {
            String json = Serialization.toJson(fieldList);
            this.getClient().put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update QR codes in document.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update QR codes in document. Exception: " + e.getMessage());
        }
    }
}

