/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.CompletionReport;
import com.silanis.esl.sdk.DelegationReport;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageStatus;
import com.silanis.esl.sdk.UsageReport;
import com.silanis.esl.sdk.internal.DateHelper;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.CompletionReportConverter;
import com.silanis.esl.sdk.internal.converter.DelegationReportConverter;
import com.silanis.esl.sdk.internal.converter.PackageStatusConverter;
import com.silanis.esl.sdk.internal.converter.UsageReportConverter;
import com.silanis.esl.sdk.service.EslComponent;
import java.util.Date;

public class ReportService
extends EslComponent {
    public ReportService(RestClient client, String baseUrl) {
        super(client, baseUrl);
    }

    public CompletionReport downloadCompletionReport(PackageStatus packageStatus, String senderId, Date from, Date to) {
        String path = this.buildCompletionReportUrl(packageStatus, senderId, from, to);
        try {
            String json = this.getClient().get(path);
            com.silanis.esl.api.model.CompletionReport apiCompletionReport = Serialization.fromJson(json, com.silanis.esl.api.model.CompletionReport.class);
            return new CompletionReportConverter(apiCompletionReport).toSDKCompletionReport();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the completion report.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the completion report. Exception: " + e.getMessage());
        }
    }

    public String downloadCompletionReportAsCSV(PackageStatus packageStatus, String senderId, Date from, Date to) {
        String path = this.buildCompletionReportUrl(packageStatus, senderId, from, to);
        try {
            return this.getClient().get(path, "text/csv");
        }
        catch (RequestException e) {
            throw new EslException("Could not download the completion report in csv.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the completion report in csv. Exception: " + e.getMessage());
        }
    }

    public CompletionReport downloadCompletionReport(PackageStatus packageStatus, Date from, Date to) {
        String path = this.buildCompletionReportUrl(packageStatus, from, to);
        try {
            String json = this.getClient().get(path);
            com.silanis.esl.api.model.CompletionReport apiCompletionReport = Serialization.fromJson(json, com.silanis.esl.api.model.CompletionReport.class);
            return new CompletionReportConverter(apiCompletionReport).toSDKCompletionReport();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the completion report.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the completion report. Exception: " + e.getMessage());
        }
    }

    public String downloadCompletionReportAsCSV(PackageStatus packageStatus, Date from, Date to) {
        String path = this.buildCompletionReportUrl(packageStatus, from, to);
        try {
            return this.getClient().get(path, "text/csv");
        }
        catch (RequestException e) {
            throw new EslException("Could not download the completion report in csv.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the completion report in csv. Exception: " + e.getMessage());
        }
    }

    public UsageReport downloadUsageReport(Date from, Date to) {
        String path = this.buildUsageReportUrl(from, to);
        try {
            String json = this.getClient().get(path);
            com.silanis.esl.api.model.UsageReport apiUsageReport = Serialization.fromJson(json, com.silanis.esl.api.model.UsageReport.class);
            return new UsageReportConverter(apiUsageReport).toSDKUsageReport();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the usage report.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the usage report. Exception: " + e.getMessage());
        }
    }

    public String downloadUsageReportAsCSV(Date from, Date to) {
        String path = this.buildUsageReportUrl(from, to);
        try {
            return this.getClient().get(path, "text/csv");
        }
        catch (RequestException e) {
            throw new EslException("Could not download the usage report in csv.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the usage report in csv. Exception: " + e.getMessage());
        }
    }

    public DelegationReport downloadDelegationReport() {
        String path = this.buildDelegationReportUrl();
        try {
            String json = this.getClient().get(path);
            com.silanis.esl.api.model.DelegationReport apiDelegationReport = Serialization.fromJson(json, com.silanis.esl.api.model.DelegationReport.class);
            return new DelegationReportConverter(apiDelegationReport).toSDKDelegationReport();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the delegation report.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the delegation report. Exception: " + e.getMessage());
        }
    }

    public DelegationReport downloadDelegationReport(Date from, Date to) {
        String path = this.buildDelegationReportUrl(from, to);
        try {
            String json = this.getClient().get(path);
            com.silanis.esl.api.model.DelegationReport apiDelegationReport = Serialization.fromJson(json, com.silanis.esl.api.model.DelegationReport.class);
            return new DelegationReportConverter(apiDelegationReport).toSDKDelegationReport();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the delegation report.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the delegation report. Exception: " + e.getMessage());
        }
    }

    public DelegationReport downloadDelegationReport(String senderId, Date from, Date to) {
        String path = this.buildDelegationReportUrl(senderId, from, to);
        try {
            String json = this.getClient().get(path);
            com.silanis.esl.api.model.DelegationReport apiDelegationReport = Serialization.fromJson(json, com.silanis.esl.api.model.DelegationReport.class);
            return new DelegationReportConverter(apiDelegationReport).toSDKDelegationReport();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download the delegation report.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the delegation report. Exception: " + e.getMessage());
        }
    }

    public String downloadDelegationReportAsCSV() {
        String path = this.buildDelegationReportUrl();
        try {
            return this.getClient().get(path, "text/csv");
        }
        catch (RequestException e) {
            throw new EslException("Could not download the delegation report in csv.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the delegation report in csv. Exception: " + e.getMessage());
        }
    }

    public String downloadDelegationReportAsCSV(Date from, Date to) {
        String path = this.buildDelegationReportUrl(from, to);
        try {
            return this.getClient().get(path, "text/csv");
        }
        catch (RequestException e) {
            throw new EslException("Could not download the delegation report in csv.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the delegation report in csv. Exception: " + e.getMessage());
        }
    }

    public String downloadDelegationReportAsCSV(String senderId, Date from, Date to) {
        String path = this.buildDelegationReportUrl(senderId, from, to);
        try {
            return this.getClient().get(path, "text/csv");
        }
        catch (RequestException e) {
            throw new EslException("Could not download the delegation report in csv.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download the delegation report in csv. Exception: " + e.getMessage());
        }
    }

    private String buildCompletionReportUrl(PackageStatus packageStatus, String senderId, Date from, Date to) {
        String toDate = DateHelper.dateToIsoUtcFormat(to);
        String fromDate = DateHelper.dateToIsoUtcFormat(from);
        return new UrlTemplate(this.getBaseUrl()).urlFor("/reports/completion?senderId={senderId}&status={status}&from={from}&to={to}").replace("{from}", fromDate).replace("{to}", toDate).replace("{status}", new PackageStatusConverter(packageStatus).toAPIPackageStatus()).replace("{senderId}", senderId).build();
    }

    private String buildCompletionReportUrl(PackageStatus packageStatus, Date from, Date to) {
        String toDate = DateHelper.dateToIsoUtcFormat(to);
        String fromDate = DateHelper.dateToIsoUtcFormat(from);
        return new UrlTemplate(this.getBaseUrl()).urlFor("/reports/completion?status={status}&from={from}&to={to}").replace("{from}", fromDate).replace("{to}", toDate).replace("{status}", new PackageStatusConverter(packageStatus).toAPIPackageStatus()).build();
    }

    private String buildUsageReportUrl(Date from, Date to) {
        String toDate = DateHelper.dateToIsoUtcFormat(to);
        String fromDate = DateHelper.dateToIsoUtcFormat(from);
        return new UrlTemplate(this.getBaseUrl()).urlFor("/reports/usage?from={from}&to={to}").replace("{from}", fromDate).replace("{to}", toDate).build();
    }

    private String buildDelegationReportUrl() {
        return new UrlTemplate(this.getBaseUrl()).urlFor("/reports/delegation").build();
    }

    private String buildDelegationReportUrl(Date from, Date to) {
        String toDate = DateHelper.dateToIsoUtcFormat(to);
        String fromDate = DateHelper.dateToIsoUtcFormat(from);
        return new UrlTemplate(this.getBaseUrl()).urlFor("/reports/delegation").build().concat("?from={from}&to={to}").replace("{from}", fromDate).replace("{to}", toDate);
    }

    private String buildDelegationReportUrl(String senderId, Date from, Date to) {
        String toDate = DateHelper.dateToIsoUtcFormat(to);
        String fromDate = DateHelper.dateToIsoUtcFormat(from);
        return new UrlTemplate(this.getBaseUrl()).urlFor("/reports/delegation").build().concat("?senderId={senderId}&from={from}&to={to}").replace("{senderId}", senderId).replace("{from}", fromDate).replace("{to}", toDate);
    }
}

