/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.service.EslComponent;

public class SessionService
extends EslComponent {
    public SessionService(RestClient client, String baseUrl) {
        super(client, baseUrl);
    }

    public SessionToken createSessionToken(String packageId, String signerId) throws EslException {
        String stringResponse;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/sessions?package={packageId}&signer={signerId}").replace("{packageId}", packageId).replace("{signerId}", signerId).build();
        try {
            stringResponse = this.getClient().post(path, "");
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a session token for signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a session token for signer.", e);
        }
        return Serialization.fromJson(stringResponse, SessionToken.class);
    }

    public SessionToken createSenderSessionToken() throws EslException {
        String stringResponse;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/sessions").build();
        try {
            stringResponse = this.getClient().post(path, "");
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a session token for sender.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a session token for sender.", e);
        }
        return Serialization.fromJson(stringResponse, SessionToken.class);
    }
}

