/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.SignatureImageFormat;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.service.EslComponent;

public class SignatureImageService
extends EslComponent {
    public SignatureImageService(RestClient client, String baseUrl) {
        super(client, baseUrl);
    }

    public DownloadedFile getSignatureImageForSender(String senderId, SignatureImageFormat imageFormat) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/account/senders/{senderId}/signatureImage").replace("{senderId}", senderId).build();
        try {
            return this.getClient().getBytes(path, imageFormat.getAcceptType());
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download signature image for sender.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download signature image for sender. Exception: " + e.getMessage());
        }
    }

    public DownloadedFile getSignatureImageForPackageRole(PackageId packageId, String signerId, SignatureImageFormat imageFormat) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/roles/{roleId}/signatureImage").replace("{packageId}", packageId.getId()).replace("{roleId}", signerId).build();
        try {
            return this.getClient().getBytes(path, imageFormat.getAcceptType());
        }
        catch (RequestException e) {
            throw new EslServerException("Could not download signature image for package signer.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not download signature image for package signer. Exception: " + e.getMessage());
        }
    }
}

