/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.BasePackageType;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.BasePackageTypeConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import com.silanis.esl.sdk.service.EslComponent;
import com.silanis.esl.sdk.service.PackageService;
import java.util.ArrayList;

public class TemplateService
extends EslComponent {
    private PackageService packageService;

    public TemplateService(RestClient client, String baseUrl, PackageService packageService) {
        super(client, baseUrl);
        this.packageService = packageService;
    }

    public PackageId createTemplateFromPackage(PackageId originalPackageId, DocumentPackage delta) {
        Package returnedPackage;
        Package deltaPackage = new DocumentPackageConverter(delta).toAPIPackage();
        deltaPackage.setType(new BasePackageTypeConverter(BasePackageType.TEMPLATE).toAPIBasePackageType());
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/clone").replace("{packageId}", originalPackageId.getId()).build();
        String deltaJson = Serialization.toJson(deltaPackage);
        try {
            String response = this.getClient().post(path, deltaJson);
            returnedPackage = Serialization.fromJson(response, Package.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create template", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create template", e);
        }
        return new DocumentPackageConverter(returnedPackage).toSDKPackage().getId();
    }

    public PackageId createTemplateFromPackage(PackageId originalPackageId, String templateName) {
        DocumentPackage sdkPackage = PackageBuilder.newPackageNamed(templateName).build();
        return this.createTemplateFromPackage(originalPackageId, sdkPackage);
    }

    @Deprecated
    public PackageId createPackageFromTemplate(DocumentPackage documentPackage, PackageId packageId) {
        return this.createPackageFromTemplate(packageId, documentPackage);
    }

    public PackageId createPackageFromTemplate(PackageId packageId, DocumentPackage documentPackage) {
        Package createdPackage;
        this.setNewSignersIndexIfRoleWorkflowEnabled(packageId, documentPackage);
        Package packageToCreate = new DocumentPackageConverter(documentPackage).toAPIPackage();
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/clone").replace("{packageId}", packageId.getId()).build();
        String packageJson = Serialization.toJson(packageToCreate);
        try {
            String response = this.getClient().post(path, packageJson);
            createdPackage = Serialization.fromJson(response, Package.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create a new package from template", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create a new package from template", e);
        }
        return new PackageId(createdPackage.getId());
    }

    private void setNewSignersIndexIfRoleWorkflowEnabled(PackageId packageId, DocumentPackage documentPackage) {
        DocumentPackage template = new DocumentPackageConverter(this.packageService.getApiPackage(packageId.getId())).toSDKPackage();
        if (this.checkSignerOrdering(template)) {
            int firstSignerIndex = this.getMaxSigningOrder(template, documentPackage) + 1;
            for (Signer signer : documentPackage.getSigners()) {
                Signer templatePlaceholder = template.getPlaceholder(signer.getId());
                if (templatePlaceholder != null) {
                    signer.setSigningOrder(templatePlaceholder.getSigningOrder());
                }
                if (signer.getSigningOrder() > 0) continue;
                signer.setSigningOrder(firstSignerIndex);
                ++firstSignerIndex;
            }
        }
    }

    private int getMaxSigningOrder(DocumentPackage template, DocumentPackage documentPackage) {
        ArrayList<Signer> signers = new ArrayList<Signer>();
        signers.addAll(documentPackage.getSigners());
        signers.addAll(template.getSigners());
        int maxSigningOrder = 0;
        for (Signer signer : signers) {
            if (signer.getSigningOrder() <= maxSigningOrder) continue;
            maxSigningOrder = signer.getSigningOrder();
        }
        return maxSigningOrder;
    }

    private boolean checkSignerOrdering(DocumentPackage template) {
        ArrayList<Signer> signers = new ArrayList<Signer>();
        signers.addAll(template.getSigners());
        signers.addAll(template.getPlaceholders());
        for (Signer signer : signers) {
            if (signer.getSigningOrder() <= 0) continue;
            return true;
        }
        return false;
    }

    public PackageId createTemplate(DocumentPackage template) {
        PackageId templateId;
        Package packageToCreate = new DocumentPackageConverter(template).toAPIPackage();
        packageToCreate.setType(new BasePackageTypeConverter(BasePackageType.TEMPLATE).toAPIBasePackageType());
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages").build();
        String packageJson = Serialization.toJson(packageToCreate);
        try {
            String response = this.getClient().post(path, packageJson);
            templateId = Serialization.fromJson(response, PackageId.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not create template", e);
        }
        catch (Exception e) {
            throw new EslException("Could not create template", e);
        }
        for (Document document : template.getDocuments()) {
            this.packageService.uploadDocument(templateId, document.getFileName(), document.getContent(), document);
        }
        return templateId;
    }

    public void updateTemplate(DocumentPackage template) {
        if (template.getId() == null) {
            throw new IllegalArgumentException("templateId cannot be null");
        }
        Package packageToUpdate = new DocumentPackageConverter(template).toAPIPackage();
        packageToUpdate.setType(new BasePackageTypeConverter(BasePackageType.TEMPLATE).toAPIBasePackageType());
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}").replace("{packageId}", packageToUpdate.getId()).build();
        String packageJson = Serialization.toJson(packageToUpdate);
        try {
            this.getClient().put(path, packageJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update template", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update template", e);
        }
    }

    public Placeholder addPlaceholder(PackageId templateId, Placeholder placeholder) throws EslException {
        String stringResponse;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/roles").replace("{packageId}", templateId.getId()).build();
        String placeholderJson = JacksonUtil.serializeDirty(placeholder);
        try {
            stringResponse = this.getClient().post(path, placeholderJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add placeholder.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add placeholder.", e);
        }
        Role role = Serialization.fromJson(stringResponse, Role.class);
        return new Placeholder(role.getId(), role.getName());
    }

    public Placeholder updatePlaceholder(PackageId templateId, Placeholder placeholder) throws EslException {
        String stringResponse;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/roles/{roleId}").replace("{packageId}", templateId.getId()).replace("{roleId}", placeholder.getId()).build();
        String placeholderJson = JacksonUtil.serializeDirty(placeholder);
        try {
            stringResponse = this.getClient().put(path, placeholderJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update the placeholder.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update the placeholder.", e);
        }
        Role role = Serialization.fromJson(stringResponse, Role.class);
        return new Placeholder(role.getId(), role.getName());
    }
}

