/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.VirtualRoom;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.internal.converter.VirtualRoomConverter;
import com.silanis.esl.sdk.service.EslComponent;

public class VirtualRoomService
extends EslComponent {
    public VirtualRoomService(RestClient client, String baseUrl) {
        super(client, baseUrl);
    }

    public VirtualRoom getVirtualRoom(PackageId packageId) {
        String stringResponse;
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/virtual-room/config").replace("{packageId}", packageId.getId()).build();
        try {
            stringResponse = this.getClient().get(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get virtual room configuration.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get virtual room configuration.", e);
        }
        com.silanis.esl.api.model.VirtualRoom virtualRoom = Serialization.fromJson(stringResponse, com.silanis.esl.api.model.VirtualRoom.class);
        VirtualRoomConverter converter = new VirtualRoomConverter(virtualRoom);
        return converter.toSDKVirtualRoom();
    }

    public void setVirtualRoom(PackageId packageId, VirtualRoom virtualRoom) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/packages/{packageId}/virtual-room/config").replace("{packageId}", packageId.getId()).build();
        VirtualRoomConverter converter = new VirtualRoomConverter(virtualRoom);
        String virtualRoomJson = Serialization.toJson(converter.toAPIVirtualRoom());
        try {
            this.getClient().put(path, virtualRoomJson);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update virtualRoom", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update virtualRoom", e);
        }
    }
}

