/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service.apiclient;

import com.silanis.esl.api.model.CustomField;
import com.silanis.esl.api.model.UserCustomField;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import com.silanis.esl.sdk.service.EslComponent;
import java.util.List;

public class CustomFieldApiClient
extends EslComponent {
    public CustomFieldApiClient(RestClient restClient, String apiUrl) {
        super(restClient, apiUrl);
    }

    public CustomField createCustomField(CustomField customField) throws EslException {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/account/customfields").build();
        try {
            String stringResponse = this.doesCustomFieldExist(customField.getId()) ? this.getClient().put(path, Serialization.toJson(customField)) : this.getClient().post(path, Serialization.toJson(customField));
            return Serialization.fromJson(stringResponse, CustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add/update the custom field to account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add/update the custom field to account.", e);
        }
    }

    public boolean doesCustomFieldExist(String id) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/account/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            String stringResponse = this.getClient().get(path);
            return stringResponse != null && !stringResponse.isEmpty();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from account.", e);
        }
    }

    public CustomField getCustomField(String id) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/account/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            String stringResponse = this.getClient().get(path);
            return Serialization.fromJson(stringResponse, CustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from account.", e);
        }
    }

    public List<CustomField> getCustomFields(Direction direction, PageRequest request) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/account/customfields?dir={dir}&from={from}&to={to}").replace("{dir}", direction.getDirection()).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).build();
        try {
            String stringResponse = this.getClient().get(path);
            return Serialization.fromJsonToList(stringResponse, CustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the list of custom fields from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the list of custom fields from account.", e);
        }
    }

    public void deleteCustomField(String id) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/account/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            this.getClient().delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the custom field from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the custom field from account.", e);
        }
    }

    public List<UserCustomField> getUserCustomFields() throws EslException {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/user/customfields").build();
        try {
            String response = this.getClient().get(path);
            return Serialization.fromJsonToList(response, UserCustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom fields for the user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom fields for the user.", e);
        }
    }

    public UserCustomField getUserCustomField(String customFieldId) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/user/customfields/{customFieldId}").replace("{customFieldId}", customFieldId).build();
        try {
            String response = this.getClient().get(path);
            return Serialization.fromJson(response, UserCustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field for the user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field for the user.", e);
        }
    }

    public UserCustomField submitCustomFieldValue(UserCustomField userCustomField) throws EslException {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/user/customfields").build();
        try {
            String payload = Serialization.toJson(userCustomField);
            String response = this.doesCustomFieldValueExist(userCustomField.getId()) ? this.getClient().put(path, payload) : this.getClient().post(path, payload);
            return Serialization.fromJson(response, UserCustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add/update the custom field to account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add/update the custom field to account.", e);
        }
    }

    public void deleteUserCustomField(String id) throws EslException {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/user/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            this.getClient().delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the custom field from user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the custom field from user.", e);
        }
    }

    public boolean doesCustomFieldValueExist(String id) {
        String path = new UrlTemplate(this.getBaseUrl()).urlFor("/user/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            String stringResponse = this.getClient().get(path);
            return stringResponse != null && !stringResponse.isEmpty();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field from user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from user.", e);
        }
    }
}

