/*
 * Decompiled with CFR 0.152.
 */
package com.simple.metrics.kafka;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.simple.metrics.kafka.DropwizardReporterConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardReporter
implements MetricsReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardReporter.class);
    protected static final String METRIC_PREFIX = MetricsReporter.class.getPackage().getName();
    protected MetricRegistry registry;
    protected DropwizardReporterConfig config;
    private Set<String> metricNames = new HashSet<String>();

    public void configure(Map<String, ?> configs) {
        this.config = new DropwizardReporterConfig(configs);
    }

    public void init(List<KafkaMetric> list) {
        if (this.config == null) {
            throw new IllegalStateException("Must call configure() before calling init() on a reporter.");
        }
        String registryName = this.config.getString("metric.dropwizard.registry");
        this.registry = SharedMetricRegistries.getOrCreate((String)registryName);
        for (KafkaMetric kafkaMetric : list) {
            this.metricChange(kafkaMetric);
        }
    }

    public void metricChange(final KafkaMetric kafkaMetric) {
        LOGGER.debug("Processing a metric change for {}", (Object)kafkaMetric.metricName().toString());
        String name = DropwizardReporter.dropwizardMetricName(kafkaMetric);
        Gauge<Double> gauge = new Gauge<Double>(){

            public Double getValue() {
                return kafkaMetric.value();
            }
        };
        LOGGER.debug("Registering {}", (Object)name);
        try {
            this.registry.register(name, (Metric)gauge);
            this.metricNames.add(name);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("metricChange called for `{}' which was already registered, ignoring.", (Object)name);
        }
    }

    public void metricRemoval(KafkaMetric kafkaMetric) {
        String name = DropwizardReporter.dropwizardMetricName(kafkaMetric);
        LOGGER.debug("Removing {}", (Object)name);
        this.registry.remove(name);
        this.metricNames.remove(name);
    }

    public void close() {
        for (String name : this.metricNames) {
            this.registry.remove(name);
        }
    }

    private static String dropwizardMetricName(KafkaMetric kafkaMetric) {
        MetricName name = kafkaMetric.metricName();
        ArrayList<String> nameParts = new ArrayList<String>(2);
        nameParts.add(name.group());
        nameParts.addAll(name.tags().values());
        nameParts.add(name.name());
        StringBuilder builder = new StringBuilder();
        for (String namePart : nameParts) {
            builder.append(namePart);
            builder.append(".");
        }
        builder.setLength(builder.length() - 1);
        String processedName = builder.toString().replace(' ', '_').replace("\\.", "_");
        return MetricRegistry.name((String)METRIC_PREFIX, (String[])new String[]{processedName});
    }
}

