/*
 * Decompiled with CFR 0.152.
 */
package com.simple.metrics.kafka;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.simple.metrics.kafka.DropwizardReporter;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardReporterGraphite
extends DropwizardReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardReporterGraphite.class);
    GraphiteSender graphite = null;
    GraphiteReporter reporter = null;

    @Override
    public void init(List<KafkaMetric> list) {
        super.init(list);
        InetSocketAddress address = new InetSocketAddress(this.config.getString("metric.dropwizard.graphite.host"), (int)this.config.getInt("metric.dropwizard.graphite.port"));
        this.graphite = new Graphite(address);
        this.reporter = GraphiteReporter.forRegistry((MetricRegistry)this.registry).prefixedWith(this.config.getString("metric.dropwizard.graphite.prefix")).build(this.graphite);
        LOGGER.info("Starting the reporter");
        this.reporter.start(11L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        LOGGER.info("Stopping and closing the reporter");
        this.reporter.stop();
        this.reporter.close();
        super.close();
    }
}

