/*
 * Decompiled with CFR 0.152.
 */
package com.simplecityapps.recyclerview_fastscroll.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import com.simplecityapps.recyclerview_fastscroll.R;
import com.simplecityapps.recyclerview_fastscroll.interfaces.OnFastScrollStateChangeListener;
import com.simplecityapps.recyclerview_fastscroll.utils.Utils;
import com.simplecityapps.recyclerview_fastscroll.views.FastScroller;

public class FastScrollRecyclerView
extends RecyclerView
implements RecyclerView.OnItemTouchListener {
    private static final String TAG = "FastScrollRecyclerView";
    private FastScroller mScrollbar;
    private boolean mFastScrollThumbEnabled = true;
    private ScrollPositionState mScrollPosState = new ScrollPositionState();
    private int mDownX;
    private int mDownY;
    private int mLastY;
    private SparseIntArray mScrollOffsets;
    private ScrollOffsetInvalidator mScrollOffsetInvalidator;
    private OnFastScrollStateChangeListener mStateChangeListener;

    public FastScrollRecyclerView(Context context) {
        this(context, null);
    }

    public FastScrollRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastScrollRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FastScrollRecyclerView, 0, 0);
        try {
            this.mFastScrollThumbEnabled = typedArray.getBoolean(R.styleable.FastScrollRecyclerView_fastScrollThumbEnabled, true);
        }
        finally {
            typedArray.recycle();
        }
        this.mScrollbar = new FastScroller(context, this, attrs);
        this.mScrollOffsetInvalidator = new ScrollOffsetInvalidator();
        this.mScrollOffsets = new SparseIntArray();
    }

    public int getScrollBarWidth() {
        return this.mScrollbar.getWidth();
    }

    public int getScrollBarThumbHeight() {
        return this.mScrollbar.getThumbHeight();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.addOnItemTouchListener(this);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.getAdapter() != null) {
            this.getAdapter().unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mScrollOffsetInvalidator);
        }
        if (adapter != null) {
            adapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mScrollOffsetInvalidator);
        }
        super.setAdapter(adapter);
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent ev) {
        return this.handleTouchEvent(ev);
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent ev) {
        this.handleTouchEvent(ev);
    }

    private boolean handleTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        int x = (int)ev.getX();
        int y = (int)ev.getY();
        switch (action) {
            case 0: {
                this.mDownX = x;
                this.mDownY = this.mLastY = y;
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
                break;
            }
            case 2: {
                this.mLastY = y;
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
                break;
            }
            case 1: 
            case 3: {
                this.mScrollbar.handleTouchEvent(ev, this.mDownX, this.mDownY, this.mLastY, this.mStateChangeListener);
            }
        }
        return this.mScrollbar.isDragging();
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    protected int getAvailableScrollHeight(int adapterHeight, int yOffset) {
        int visibleHeight = this.getHeight();
        int scrollHeight = this.getPaddingTop() + yOffset + adapterHeight + this.getPaddingBottom();
        int availableScrollHeight = scrollHeight - visibleHeight;
        return availableScrollHeight;
    }

    protected int getAvailableScrollBarHeight() {
        int visibleHeight = this.getHeight();
        int availableScrollBarHeight = visibleHeight - this.mScrollbar.getThumbHeight();
        return availableScrollBarHeight;
    }

    public void draw(Canvas c) {
        super.draw(c);
        if (this.mFastScrollThumbEnabled) {
            this.onUpdateScrollbar();
            this.mScrollbar.draw(c);
        }
    }

    protected void updateThumbPosition(ScrollPositionState scrollPosState, int rowCount) {
        int scrolledPastHeight;
        int availableScrollHeight;
        if (this.getAdapter() instanceof MeasurableAdapter) {
            availableScrollHeight = this.getAvailableScrollHeight(this.calculateAdapterHeight(), 0);
            scrolledPastHeight = this.calculateScrollDistanceToPosition(scrollPosState.rowIndex);
        } else {
            availableScrollHeight = this.getAvailableScrollHeight(rowCount * scrollPosState.rowHeight, 0);
            scrolledPastHeight = scrollPosState.rowIndex * scrollPosState.rowHeight;
        }
        int availableScrollBarHeight = this.getAvailableScrollBarHeight();
        if (availableScrollHeight <= 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        int scrollY = this.getPaddingTop() + scrolledPastHeight - scrollPosState.rowTopOffset;
        int scrollBarY = (int)((float)scrollY / (float)availableScrollHeight * (float)availableScrollBarHeight);
        int scrollBarX = Utils.isRtl(this.getResources()) ? 0 : this.getWidth() - this.mScrollbar.getWidth();
        this.mScrollbar.setThumbPosition(scrollBarX, scrollBarY);
    }

    public String scrollToPositionAtProgress(float touchFraction) {
        int scrollOffset;
        int scrollPosition;
        float itemPos;
        int itemCount = this.getAdapter().getItemCount();
        if (itemCount == 0) {
            return "";
        }
        int spanCount = 1;
        int rowCount = itemCount;
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        this.stopScroll();
        this.getCurScrollState(this.mScrollPosState);
        if (this.getAdapter() instanceof MeasurableAdapter) {
            itemPos = this.findItemPosition(touchFraction);
            int availableScrollHeight = this.calculateAdapterHeight();
            scrollPosition = (int)itemPos;
            scrollOffset = this.calculateScrollDistanceToPosition(scrollPosition) - (int)(touchFraction * (float)availableScrollHeight);
        } else {
            itemPos = this.findItemPosition(touchFraction);
            int availableScrollHeight = this.getAvailableScrollHeight(rowCount * this.mScrollPosState.rowHeight, 0);
            int exactItemPos = (int)((float)availableScrollHeight * touchFraction);
            scrollPosition = spanCount * exactItemPos / this.mScrollPosState.rowHeight;
            scrollOffset = -(exactItemPos % this.mScrollPosState.rowHeight);
        }
        LinearLayoutManager layoutManager = (LinearLayoutManager)this.getLayoutManager();
        layoutManager.scrollToPositionWithOffset(scrollPosition, scrollOffset);
        if (!(this.getAdapter() instanceof SectionedAdapter)) {
            return "";
        }
        int posInt = (int)(touchFraction == 1.0f ? itemPos - 1.0f : itemPos);
        SectionedAdapter sectionedAdapter = (SectionedAdapter)this.getAdapter();
        return sectionedAdapter.getSectionName(posInt);
    }

    private float findItemPosition(float touchFraction) {
        if (this.getAdapter() instanceof MeasurableAdapter) {
            MeasurableAdapter measurer = (MeasurableAdapter)this.getAdapter();
            int viewTop = (int)(touchFraction * (float)this.calculateAdapterHeight());
            for (int i = 0; i < this.getAdapter().getItemCount(); ++i) {
                int top = this.calculateScrollDistanceToPosition(i);
                int bottom = top + measurer.getViewTypeHeight(this, this.getAdapter().getItemViewType(i));
                if (viewTop < top || viewTop > bottom) continue;
                return i;
            }
            Log.w((String)TAG, (String)("Failed to find a view at the provided scroll fraction (" + touchFraction + ")"));
            return touchFraction * (float)this.getAdapter().getItemCount();
        }
        return (float)this.getAdapter().getItemCount() * touchFraction;
    }

    public void onUpdateScrollbar() {
        if (this.getAdapter() == null) {
            return;
        }
        int rowCount = this.getAdapter().getItemCount();
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            int spanCount = ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
            rowCount = (int)Math.ceil((double)rowCount / (double)spanCount);
        }
        if (rowCount == 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        this.getCurScrollState(this.mScrollPosState);
        if (this.mScrollPosState.rowIndex < 0) {
            this.mScrollbar.setThumbPosition(-1, -1);
            return;
        }
        this.updateThumbPosition(this.mScrollPosState, rowCount);
    }

    private void getCurScrollState(ScrollPositionState stateOut) {
        stateOut.rowIndex = -1;
        stateOut.rowTopOffset = -1;
        stateOut.rowHeight = -1;
        int itemCount = this.getAdapter().getItemCount();
        if (itemCount == 0 || this.getChildCount() == 0) {
            return;
        }
        View child = this.getChildAt(0);
        stateOut.rowIndex = this.getChildAdapterPosition(child);
        if (this.getLayoutManager() instanceof GridLayoutManager) {
            stateOut.rowIndex /= ((GridLayoutManager)this.getLayoutManager()).getSpanCount();
        }
        stateOut.rowTopOffset = this.getLayoutManager().getDecoratedTop(child);
        stateOut.rowHeight = child.getHeight() + this.getLayoutManager().getTopDecorationHeight(child) + this.getLayoutManager().getBottomDecorationHeight(child);
    }

    private int calculateScrollDistanceToPosition(int adapterIndex) {
        if (!(this.getAdapter() instanceof MeasurableAdapter)) {
            throw new IllegalStateException("calculateScrollDistanceToPosition() should only be called where the RecyclerView.Adapter is an instance of MeasurableAdapter");
        }
        if (this.mScrollOffsets.indexOfKey(adapterIndex) >= 0) {
            return this.mScrollOffsets.get(adapterIndex);
        }
        int totalHeight = 0;
        MeasurableAdapter measurer = (MeasurableAdapter)this.getAdapter();
        for (int i = 0; i < adapterIndex; ++i) {
            this.mScrollOffsets.put(i, totalHeight);
            int viewType = this.getAdapter().getItemViewType(i);
            totalHeight += measurer.getViewTypeHeight(this, viewType);
        }
        this.mScrollOffsets.put(adapterIndex, totalHeight);
        return totalHeight;
    }

    private int calculateAdapterHeight() {
        if (!(this.getAdapter() instanceof MeasurableAdapter)) {
            throw new IllegalStateException("calculateAdapterHeight() should only be called where the RecyclerView.Adapter is an instance of MeasurableAdapter");
        }
        return this.calculateScrollDistanceToPosition(this.getAdapter().getItemCount());
    }

    public void setThumbColor(@ColorInt int color) {
        this.mScrollbar.setThumbColor(color);
    }

    public void setTrackColor(@ColorInt int color) {
        this.mScrollbar.setTrackColor(color);
    }

    public void setPopupBgColor(@ColorInt int color) {
        this.mScrollbar.setPopupBgColor(color);
    }

    public void setPopupTextColor(@ColorInt int color) {
        this.mScrollbar.setPopupTextColor(color);
    }

    public void setPopupTextSize(int textSize) {
        this.mScrollbar.setPopupTextSize(textSize);
    }

    public void setPopUpTypeface(Typeface typeface) {
        this.mScrollbar.setPopupTypeface(typeface);
    }

    public void setAutoHideDelay(int hideDelay) {
        this.mScrollbar.setAutoHideDelay(hideDelay);
    }

    public void setAutoHideEnabled(boolean autoHideEnabled) {
        this.mScrollbar.setAutoHideEnabled(autoHideEnabled);
    }

    public void setStateChangeListener(OnFastScrollStateChangeListener stateChangeListener) {
        this.mStateChangeListener = stateChangeListener;
    }

    public void setThumbInactiveColor(boolean autoHideEnabled) {
        this.mScrollbar.setThumbInactiveColor(autoHideEnabled);
    }

    public void setThumbEnabled(boolean thumbEnabled) {
        this.mFastScrollThumbEnabled = thumbEnabled;
    }

    public void setPopupPosition(int popupPosition) {
        this.mScrollbar.setPopupPosition(popupPosition);
    }

    public static interface MeasurableAdapter {
        public int getViewTypeHeight(RecyclerView var1, int var2);
    }

    public static interface SectionedAdapter {
        @NonNull
        public String getSectionName(int var1);
    }

    private class ScrollOffsetInvalidator
    extends RecyclerView.AdapterDataObserver {
        private ScrollOffsetInvalidator() {
        }

        private void invalidateAllScrollOffsets() {
            FastScrollRecyclerView.this.mScrollOffsets.clear();
        }

        public void onChanged() {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            this.invalidateAllScrollOffsets();
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.invalidateAllScrollOffsets();
        }
    }

    public static class ScrollPositionState {
        int rowIndex;
        int rowTopOffset;
        int rowHeight;
    }
}

