/*
 * Decompiled with CFR 0.152.
 */
package com.simplecityapps.recyclerview_fastscroll.views;

import android.animation.ObjectAnimator;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextUtils;
import androidx.annotation.Keep;
import com.simplecityapps.recyclerview_fastscroll.utils.Utils;
import com.simplecityapps.recyclerview_fastscroll.views.FastScrollRecyclerView;
import com.simplecityapps.recyclerview_fastscroll.views.FastScroller;

public class FastScrollPopup {
    private FastScrollRecyclerView mRecyclerView;
    private Resources mRes;
    private int mBackgroundSize;
    private int mCornerRadius;
    private Path mBackgroundPath = new Path();
    private RectF mBackgroundRect = new RectF();
    private Paint mBackgroundPaint;
    private int mBackgroundColor = -16777216;
    private Rect mInvalidateRect = new Rect();
    private Rect mTmpRect = new Rect();
    private Rect mBgBounds = new Rect();
    private String mSectionName;
    private Paint mTextPaint;
    private Rect mTextBounds = new Rect();
    private float mAlpha = 1.0f;
    private ObjectAnimator mAlphaAnimator;
    private boolean mVisible;
    private int mTextVerticalAlignmentMode;
    @FastScroller.PopupPosition
    private int mPosition;

    FastScrollPopup(Resources resources, FastScrollRecyclerView recyclerView) {
        this.mRes = resources;
        this.mRecyclerView = recyclerView;
        this.mBackgroundPaint = new Paint(1);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setAlpha(0);
        this.setTextSize(Utils.toScreenPixels(this.mRes, 44.0f));
        this.setBackgroundSize(Utils.toPixels(this.mRes, 88.0f));
    }

    public void setBgColor(int color) {
        this.mBackgroundColor = color;
        this.mBackgroundPaint.setColor(color);
        this.mRecyclerView.invalidate(this.mBgBounds);
    }

    public void setTextColor(int color) {
        this.mTextPaint.setColor(color);
        this.mRecyclerView.invalidate(this.mBgBounds);
    }

    public void setTextSize(int size) {
        this.mTextPaint.setTextSize((float)size);
        this.mRecyclerView.invalidate(this.mBgBounds);
    }

    public void setBackgroundSize(int size) {
        this.mBackgroundSize = size;
        this.mCornerRadius = this.mBackgroundSize / 2;
        this.mRecyclerView.invalidate(this.mBgBounds);
    }

    public void setTypeface(Typeface typeface) {
        this.mTextPaint.setTypeface(typeface);
        this.mRecyclerView.invalidate(this.mBgBounds);
    }

    public void animateVisibility(boolean visible) {
        if (this.mVisible != visible) {
            this.mVisible = visible;
            if (this.mAlphaAnimator != null) {
                this.mAlphaAnimator.cancel();
            }
            this.mAlphaAnimator = ObjectAnimator.ofFloat((Object)this, (String)"alpha", (float[])new float[]{visible ? 1.0f : 0.0f});
            this.mAlphaAnimator.setDuration(visible ? 200L : 150L);
            this.mAlphaAnimator.start();
        }
    }

    @Keep
    public void setAlpha(float alpha) {
        this.mAlpha = alpha;
        this.mRecyclerView.invalidate(this.mBgBounds);
    }

    @Keep
    public float getAlpha() {
        return this.mAlpha;
    }

    public void setPopupTextVerticalAlignmentMode(int mode) {
        this.mTextVerticalAlignmentMode = mode;
    }

    public int getPopupTextVerticalAlignmentMode() {
        return this.mTextVerticalAlignmentMode;
    }

    public void setPopupPosition(@FastScroller.PopupPosition int position) {
        this.mPosition = position;
    }

    @FastScroller.PopupPosition
    public int getPopupPosition() {
        return this.mPosition;
    }

    private float[] createRadii() {
        if (this.mPosition == 1) {
            return new float[]{this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius};
        }
        if (Utils.isRtl(this.mRes)) {
            return new float[]{this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, 0.0f, 0.0f};
        }
        return new float[]{this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, this.mCornerRadius, 0.0f, 0.0f, this.mCornerRadius, this.mCornerRadius};
    }

    public void draw(Canvas canvas) {
        if (this.isVisible()) {
            float baselinePosition;
            int restoreCount = canvas.save();
            canvas.translate((float)this.mBgBounds.left, (float)this.mBgBounds.top);
            this.mTmpRect.set(this.mBgBounds);
            this.mTmpRect.offsetTo(0, 0);
            this.mBackgroundPath.reset();
            this.mBackgroundRect.set(this.mTmpRect);
            float[] radii = this.createRadii();
            if (this.mTextVerticalAlignmentMode == 1) {
                Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
                baselinePosition = ((float)this.mBgBounds.height() - fontMetrics.ascent - fontMetrics.descent) / 2.0f;
            } else {
                baselinePosition = (float)(this.mBgBounds.height() + this.mTextBounds.height()) / 2.0f;
            }
            this.mBackgroundPath.addRoundRect(this.mBackgroundRect, radii, Path.Direction.CW);
            this.mBackgroundPaint.setAlpha((int)((float)Color.alpha((int)this.mBackgroundColor) * this.mAlpha));
            this.mTextPaint.setAlpha((int)(this.mAlpha * 255.0f));
            canvas.drawPath(this.mBackgroundPath, this.mBackgroundPaint);
            canvas.drawText(this.mSectionName, (float)(this.mBgBounds.width() - this.mTextBounds.width()) / 2.0f, baselinePosition, this.mTextPaint);
            canvas.restoreToCount(restoreCount);
        }
    }

    public void setSectionName(String sectionName) {
        if (!sectionName.equals(this.mSectionName)) {
            this.mSectionName = sectionName;
            this.mTextPaint.getTextBounds(sectionName, 0, sectionName.length(), this.mTextBounds);
            this.mTextBounds.right = (int)((float)this.mTextBounds.left + this.mTextPaint.measureText(sectionName));
        }
    }

    public Rect updateFastScrollerBounds(FastScrollRecyclerView recyclerView, int thumbOffsetY) {
        this.mInvalidateRect.set(this.mBgBounds);
        if (this.isVisible()) {
            int edgePadding = recyclerView.getScrollBarWidth();
            int bgPadding = Math.round((float)(this.mBackgroundSize - this.mTextBounds.height()) / 10.0f) * 5;
            int bgHeight = this.mBackgroundSize;
            int bgWidth = Math.max(this.mBackgroundSize, this.mTextBounds.width() + 2 * bgPadding);
            if (this.mPosition == 1) {
                this.mBgBounds.left = (recyclerView.getWidth() - bgWidth) / 2;
                this.mBgBounds.right = this.mBgBounds.left + bgWidth;
                this.mBgBounds.top = (recyclerView.getHeight() - bgHeight) / 2;
            } else {
                if (Utils.isRtl(this.mRes)) {
                    this.mBgBounds.left = 2 * recyclerView.getScrollBarWidth();
                    this.mBgBounds.right = this.mBgBounds.left + bgWidth;
                } else {
                    this.mBgBounds.right = recyclerView.getWidth() - 2 * recyclerView.getScrollBarWidth();
                    this.mBgBounds.left = this.mBgBounds.right - bgWidth;
                }
                this.mBgBounds.top = recyclerView.getPaddingTop() - recyclerView.getPaddingBottom() + thumbOffsetY - bgHeight + recyclerView.getScrollBarThumbHeight() / 2;
                this.mBgBounds.top = Math.max(recyclerView.getPaddingTop() + edgePadding, Math.min(this.mBgBounds.top, recyclerView.getPaddingTop() + recyclerView.getHeight() - edgePadding - bgHeight));
            }
            this.mBgBounds.bottom = this.mBgBounds.top + bgHeight;
        } else {
            this.mBgBounds.setEmpty();
        }
        this.mInvalidateRect.union(this.mBgBounds);
        return this.mInvalidateRect;
    }

    public boolean isVisible() {
        return this.mAlpha > 0.0f && !TextUtils.isEmpty((CharSequence)this.mSectionName);
    }
}

