package com.simplj.di.annotations;

import java.lang.annotation.*;

/**
 * Use this annotation to define a constant. Below are the options:
 * <p>
 * `id` - can be used to assign an unique id against the constant
 */
@Documented
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Constant {
    String id();
    String[] tags() default {};
    String[] profiles() default {};
}
