package com.simplj.di.core;

import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
interface Tri<T, U, V, R> {

    R apply(T t, U u, V v);

    default <W> Tri<T, U, V, W> andThen(Function<? super R, ? extends W> after) {
        Objects.requireNonNull(after);
        return (T t, U u, V v) -> after.apply(apply(t, u, v));
    }
}
