package com.simplj.di.exceptions;

import java.util.LinkedList;
import java.util.List;

public class CircularDependencyException extends SdfException {
    private List<String> chain;

    public CircularDependencyException(String className) {
        this("Circular Dependency Found", className);
    }

    public CircularDependencyException(String message, String className) {
        super(message);
        this.chain = new LinkedList<>();
        chain.add(className);
    }

    public CircularDependencyException addChain(String className) {
        chain.add(0, className);
        return this;
    }

    public String getMessage() {
        return String.format("%s - Chain: %s", super.getMessage(), String.join(" -> ", chain));
    }
}
