package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.*;

final class Scanner {
    private static final String CLASS_EXT = ".class";

    static Set<Class<?>> scanForAnnotatedClasses(String basePackage, Class<? extends Annotation> annotation) {
        Set<Class<?>> classes = new HashSet<>();
        List<File> pkgDirs = new LinkedList<>();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String pkgPath = basePackage.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(pkgPath);
            URL temp;
            while (resources.hasMoreElements()) {
                temp = resources.nextElement();
                pkgDirs.add(new File(temp.getFile()));
            }
            for (File pkgDir : pkgDirs) {
                loadClasses(classes, pkgDir, basePackage, annotation);
            }
        } catch (Exception ex) {
            throw new SdfException("Could not load classes for package: " + basePackage);
        }
        return classes;
    }

    private static void loadClasses(Set<Class<?>> classes, File pkgDir, String pkg, Class<? extends Annotation> annotation) throws ClassNotFoundException {
        File[] files;
        if (null != pkgDir && pkgDir.exists() && (files = pkgDir.listFiles()) != null) {
            Class<?> temp;
            for (File file : files) {
                if (file.getName().endsWith(CLASS_EXT)) {
                    temp = Class.forName(fullyQualifiedClassName(pkg, file.getName()));
                    if (temp.isAnnotationPresent(annotation)) {
                        classes.add(temp);
                    }
                } else if (file.isDirectory()) {
                    loadClasses(classes, file, pkg + "." + file.getName(), annotation);
                }
            }
        }
    }

    private static String fullyQualifiedClassName(String pkg, String className) {
        return String.format("%s.%s", pkg, className.substring(0, className.length() - CLASS_EXT.length()));
    }
}
