/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.core;

import com.simplj.di.exceptions.SdfException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.stream.Collectors;

public abstract class TypeClass<T> {
    private final String name;
    private final Type type = this.getWrappedType();
    private final Class<T> rawType;

    public TypeClass() throws ClassNotFoundException {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.type;
            this.name = String.format("%s<%s>", pt.getRawType().getTypeName(), Arrays.stream(pt.getActualTypeArguments()).map(Type::getTypeName).collect(Collectors.joining(",")));
            this.rawType = Class.forName(pt.getRawType().getTypeName());
        } else {
            this.name = this.type.getTypeName();
            this.rawType = Class.forName(this.name);
        }
    }

    private Type getWrappedType() {
        Type gType = this.getClass().getGenericSuperclass();
        if (gType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)gType;
            return pType.getActualTypeArguments()[0];
        }
        throw new SdfException(gType.getTypeName() + " is not a generic type! TypeClass<T> must be used for generic type classes!");
    }

    public final String getName() {
        return this.name;
    }

    public final Class<T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final String toString() {
        return this.getName();
    }

    protected final void finalize() throws Throwable {
        super.finalize();
    }
}

