/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.internal.CType;
import com.simplj.di.internal.GAType;
import com.simplj.di.internal.Kind;
import com.simplj.di.internal.TypeRef;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class AType
extends TypeRef {
    private final CType cType;
    private final int dimensions;
    private final String brackets;

    AType(Class<?> type, boolean crawlParents) {
        super(type);
        List<TypeRef> parents;
        int t = 0;
        StringBuilder sb = new StringBuilder();
        while (type.isArray()) {
            ++t;
            type = type.getComponentType();
            sb.append("[]");
        }
        if (crawlParents) {
            parents = new LinkedList();
            AType.crawlParents(parents, type, type, new HashSet<String>());
        } else {
            parents = Collections.emptyList();
        }
        this.cType = new CType(type, parents);
        this.dimensions = t;
        this.brackets = sb.toString();
    }

    public CType getcType() {
        return this.cType;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    boolean isAssignableFrom(TypeRef ref) {
        boolean res = false;
        if (ref != null) {
            switch (ref.kind()) {
                case Array: {
                    AType aType = (AType)ref;
                    res = this.dimensions == aType.dimensions && this.cType.isAssignableFrom(aType.cType);
                    break;
                }
                case GenericArray: {
                    GAType gaType = (GAType)ref;
                    res = this.dimensions == gaType.getDimensions() && this.cType.isAssignableFrom(gaType.getType());
                }
            }
        }
        return res;
    }

    @Override
    public List<TypeRef> parents() {
        return this.cType.parents();
    }

    @Override
    Set<String> vTypes() {
        return Collections.emptySet();
    }

    @Override
    void updateVTypesFrom(TypeRef ref, Map<String, TypeRef> accumulator) {
    }

    @Override
    void updateVTypes(Map<String, TypeRef> varTypeMap) {
    }

    @Override
    boolean isTyped() {
        return true;
    }

    @Override
    Kind kind() {
        return Kind.Array;
    }

    @Override
    String name() {
        return String.format("%s%s", this.cType.name(), this.brackets);
    }

    @Override
    String rawName() {
        return this.name();
    }

    @Override
    String typedName() {
        return this.name();
    }

    String formattedTypeName(TypeRef ref) {
        return String.format("%s%s", ref.typedName(), this.brackets);
    }
}

