/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.DependencyInstantiator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

final class ConstructorInstantiator
extends DependencyInstantiator {
    private final Constructor<?> constructor;

    ConstructorInstantiator(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    @Override
    Class<?> type() {
        return this.constructor.getDeclaringClass();
    }

    @Override
    public Object instantiate(Object[] args) throws SdfException {
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new SdfException("Failed to instantiate '" + this.type() + "' through constructor! Reason: " + e.getMessage(), e.getCause());
        }
    }
}

