/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.ParameterMeta;
import com.simplj.di.internal.TypeUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

abstract class DependencyInstantiator {
    private Object[] args;
    private final Map<Integer, ParameterMeta> rtArgsKeyIdxMap = new HashMap<Integer, ParameterMeta>();

    DependencyInstantiator() {
    }

    abstract Class<?> type();

    abstract Object instantiate(Object[] var1) throws SdfException;

    DependencyInstantiator setArgs(Object[] args) {
        this.args = args;
        int argsLength = args.length;
        for (int i = 0; i < argsLength; ++i) {
            Object arg = args[i];
            if (!(arg instanceof ParameterMeta)) continue;
            ParameterMeta rtp = (ParameterMeta)arg;
            this.rtArgsKeyIdxMap.put(i, rtp);
        }
        return this;
    }

    boolean isRuntimeProvided() {
        return !this.rtArgsKeyIdxMap.isEmpty();
    }

    <T> T instantiate(Class<T> type) throws SdfException {
        Object o = this.instantiate(this.args);
        return TypeUtil.typeCast(type, o);
    }

    Object instantiate() throws SdfException {
        return this.instantiate(this.args);
    }

    Object instantiate(Map<String, Object> rtParams) throws SdfException {
        Object[] rtArgs = Arrays.copyOf(this.args, this.args.length);
        for (Map.Entry<Integer, ParameterMeta> entry : this.rtArgsKeyIdxMap.entrySet()) {
            ParameterMeta rtp = entry.getValue();
            Object temp = rtParams.get(rtp.key());
            if (temp == null) {
                if (rtp.isNullable()) {
                    rtArgs[entry.getKey().intValue()] = null;
                    continue;
                }
                throw new SdfException("Failed to instantiate '" + this.type() + "'! Reason: Could not find not-nullable dependency [" + rtp.key() + "]. Hint: Mark the parameter as `nullable=true` if optional.");
            }
            rtArgs[entry.getKey().intValue()] = TypeUtil.typeCast(rtp.type(), temp);
        }
        return this.instantiate(rtArgs);
    }
}

