/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.annotations.Dependency;
import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.Argument;
import com.simplj.di.internal.CommonUtil;
import com.simplj.di.internal.DependencyDef;
import com.simplj.di.internal.DependencyInstantiator;
import com.simplj.di.internal.DependencyUtil;
import com.simplj.di.internal.Scanner;
import com.simplj.di.internal.TypeRef;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class DependencyLoader {
    private final String SDF_CONST_KEY = "sdf_consts.";
    private final Object[] dependencyProviders;
    private final String[] basePackages;
    private final Properties properties;
    private final String profile;
    private final String profileMessage;
    private final Consumer<String> logger;
    private final Map<String, Set<DependencyDef>> dependencyRefMap;

    private DependencyLoader(Object[] dependencyProviders, String[] basePackages, Properties properties, String profile, Consumer<String> logger) throws SdfException {
        this.dependencyProviders = dependencyProviders == null ? new Object[]{} : dependencyProviders;
        this.basePackages = basePackages == null ? new String[]{} : basePackages;
        Properties properties2 = this.properties = properties == null ? new Properties() : properties;
        if (profile == null) {
            this.profile = "";
            this.profileMessage = "";
        } else {
            this.profile = profile;
            this.profileMessage = String.format(" for profile '%s'", profile);
        }
        this.logger = logger;
        this.dependencyRefMap = new HashMap<String, Set<DependencyDef>>();
        this.init();
    }

    private Object get(Type type, String tag) throws SdfException {
        TypeRef typeRef = TypeRef.fromType(type);
        DependencyDef dd = DependencyUtil.getDependency(typeRef, tag, this.dependencyRefMap);
        if (dd == null) {
            throw new SdfException("No Instance found for '" + typeRef.name() + '\'' + this.profileMessage + (CommonUtil.isEmpty(tag) ? "! Hint: Tag must be used to resolve tagged dependencies." : " with tag '" + tag + '\''));
        }
        if (dd.isRuntimeProvided()) {
            throw new SdfException(typeRef.rawName() + " has runtime provided dependencies and cannot be resolved through `resolve` method! Hint: Use `dynamicResolve()` with the necessary runtime parameters.");
        }
        return dd.instantiate();
    }

    private Object get(Type type, String tag, Map<String, Object> rtParams) throws SdfException {
        TypeRef typeRef = TypeRef.fromType(type);
        DependencyDef di = DependencyUtil.getDependency(typeRef, tag, this.dependencyRefMap);
        if (di == null) {
            throw new SdfException("No Instance found for '" + typeRef.name() + '\'' + this.profileMessage + (CommonUtil.isEmpty(tag) ? "! Hint: Tag must be used to resolve tagged dependencies." : " with tag '" + tag + '\''));
        }
        return di.instantiate(rtParams);
    }

    private Object get(String id) throws SdfException {
        DependencyDef dd = DependencyUtil.getDependency(id, this.dependencyRefMap);
        if (dd == null) {
            throw new SdfException("No Instance found for id '" + id + '\'' + this.profileMessage + '!');
        }
        if (dd.isRuntimeProvided()) {
            throw new SdfException(id + " has runtime provided dependencies and cannot be resolved through `resolve` method! Hint: Use `dynamicResolve()` with the necessary runtime parameters.");
        }
        return dd.instantiate();
    }

    private Object get(String id, Map<String, Object> rtParams) throws SdfException {
        DependencyDef di = DependencyUtil.getDependency(id, this.dependencyRefMap);
        if (di == null) {
            throw new SdfException("No Instance found for id '" + id + '\'' + this.profileMessage + '!');
        }
        return di.instantiate(rtParams);
    }

    private void init() throws SdfException {
        long start = System.currentTimeMillis();
        this.logger.accept(" - SDF: Analyzing dependencies...");
        this.loadDependencies(this.dependencyRefMap);
        this.logger.accept(" - SDF: Analysis done. No CircularDependency or MissingDependency found! Instantiating...");
        HashSet<String> initializedDeps = new HashSet<String>();
        int size = 0;
        for (Set<DependencyDef> ds : this.dependencyRefMap.values()) {
            for (DependencyDef d : ds) {
                if (initializedDeps.contains(d.getName()) && (CommonUtil.isEmpty(d.getId()) || initializedDeps.contains(d.getId()))) continue;
                this.initialize(d, this.dependencyRefMap, initializedDeps);
                ++size;
            }
        }
        this.logger.accept(" - SDF: Dependencies " + (this.profile.isEmpty() ? "" : "with Profile '" + this.profile + "' ") + "Instantiated Successfully!");
        long end = System.currentTimeMillis();
        this.logger.accept(" - SDF: Initialized with " + size + " dependencies/constants in " + this.formatTime(end - start));
    }

    private String formatTime(long millis) {
        return (double)millis / 1000.0 + " sec(s)";
    }

    private void printMaps(int n, String prefix) {
        if ((n & 1) == 1) {
            this.logger.accept("RefMap:");
            this.dependencyRefMap.forEach((k, v) -> {
                if (prefix == null || k.startsWith(prefix)) {
                    this.logger.accept(k + " ->\n\t" + v.stream().map(DependencyDef::toString).collect(Collectors.joining("\n\t")));
                }
            });
        }
    }

    private void loadDependencies(Map<String, Set<DependencyDef>> refMap) throws SdfException {
        this.loadConstants(refMap);
        LinkedList<DependencyDef> idBoundGenDeps = new LinkedList<DependencyDef>();
        HashSet<String> depDirectRefs = new HashSet<String>();
        DependencyUtil.loadDependencyProviders(this.dependencyProviders, refMap, idBoundGenDeps, depDirectRefs, this.profile);
        for (String p : this.basePackages) {
            Set<Class<?>> deps = Scanner.scanForAnnotatedClasses(p, Dependency.class);
            DependencyUtil.loadDependencies(deps, refMap, idBoundGenDeps, depDirectRefs, this.profile);
        }
        DependencyUtil.enrichIdBoundGenDeps(idBoundGenDeps, refMap, depDirectRefs);
        DependencyUtil.validateLoadedDependencies(refMap, depDirectRefs);
    }

    private void loadConstants(Map<String, Set<DependencyDef>> depMap) throws SdfException {
        for (String k : System.getProperties().stringPropertyNames()) {
            if (!k.startsWith("sdf_consts.")) continue;
            this.properties.setProperty(k.substring("sdf_consts.".length()), System.getProperty(k));
        }
        DependencyUtil.loadConstantProviders(this.properties, this.dependencyProviders, depMap, this.profile);
    }

    private void initialize(DependencyDef d, Map<String, Set<DependencyDef>> refMap, Set<String> initializedDeps) throws SdfException {
        Collection<Argument> deps = d.getDependencies().values();
        Object[] args = new Object[deps.size()];
        for (Argument a : deps) {
            DependencyDef dep;
            if (a.isRuntimeProvided()) {
                args[a.getIndex()] = a.getRuntimeProvided();
                continue;
            }
            if (a.isSubTypes()) {
                Set<DependencyDef> subTypes = DependencyUtil.getSubTypes(d, a.getTypeRef(), a.getTag(), refMap);
                for (DependencyDef st : subTypes) {
                    if (initializedDeps.contains(st.getName()) && (CommonUtil.isEmpty(st.getId()) || initializedDeps.contains(st.getId()))) continue;
                    this.initialize(st, refMap, initializedDeps);
                }
                args[a.getIndex()] = DependencyUtil.populateSubTypeArgs(a, subTypes);
                continue;
            }
            DependencyDef dependencyDef = dep = a.isIdBound() ? DependencyUtil.getDependency(a.getTypeNameOrId(), refMap) : DependencyUtil.getDependency(a.getTypeRef(), a.getTag(), refMap);
            if (!initializedDeps.contains(dep.getName()) || !CommonUtil.isEmpty(dep.getId()) && !initializedDeps.contains(dep.getId())) {
                this.initialize(dep, refMap, initializedDeps);
            }
            args[a.getIndex()] = dep.instantiate(a.getType());
        }
        DependencyInstantiator dInit = d.getInstantiator();
        dInit.setArgs(args);
        initializedDeps.add(d.getName());
        if (!CommonUtil.isEmpty(d.getId())) {
            initializedDeps.add(d.getId());
        }
    }
}

