/*
 * Decompiled with CFR 0.152.
 */
package com.simplj.di.internal;

import com.simplj.di.exceptions.SdfException;
import com.simplj.di.internal.DependencyInstantiator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

final class MethodInstantiator
extends DependencyInstantiator {
    private final Method method;
    private final Object source;

    MethodInstantiator(Method method, Object instance) {
        this.method = method;
        this.source = instance;
    }

    @Override
    boolean isRuntimeProvided() {
        return false;
    }

    @Override
    Class<?> type() {
        return this.method.getReturnType();
    }

    @Override
    public Object instantiate(Object[] args) throws SdfException {
        try {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            if (this.method.getParameterCount() != (args == null ? 0 : args.length)) {
                throw new SdfException("Error instantiating " + this.type().getTypeName() + " from " + this.method.getName() + "!\n\tExpected " + Arrays.stream(this.method.getParameters()).map(p -> p.getType().getTypeName()).collect(Collectors.toList()) + "\n\tFound: " + Arrays.toString(args));
            }
            return this.method.invoke(this.source, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new SdfException("Failed to instantiate '" + this.type() + "' through method '" + this.method.getName() + "'! Reason: " + e.getMessage(), e.getCause());
        }
    }
}

